/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericLongAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class LongFieldMapper
extends NumberFieldMapper {
    public static final String CONTENT_TYPE = "long";

    protected LongFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, indexSettings, multiFields, copyTo);
    }

    @Override
    public LongFieldType fieldType() {
        return (LongFieldType)super.fieldType();
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<Field> fields) throws IOException {
        long value;
        float boost = this.fieldType().boost();
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.fieldType().nullValue() == null) {
                    return;
                }
                value = this.fieldType().nullValue();
            } else if (externalValue instanceof String) {
                String sExternalValue = (String)externalValue;
                if (sExternalValue.length() == 0) {
                    if (this.fieldType().nullValue() == null) {
                        return;
                    }
                    value = this.fieldType().nullValue();
                } else {
                    value = Long.parseLong(sExternalValue);
                }
            } else {
                value = ((Number)externalValue).longValue();
            }
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.fieldType().names().fullName(), Long.toString(value), boost);
            }
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL || parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
                if (this.fieldType().nullValue() == null) {
                    return;
                }
                value = this.fieldType().nullValue();
                if (this.fieldType().nullValueAsString() != null && context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.fieldType().names().fullName(), this.fieldType().nullValueAsString(), boost);
                }
            } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                String currentFieldName = null;
                Long objValue = this.fieldType().nullValue();
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        objValue = parser.longValue((Boolean)this.coerce.value());
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new IllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
                if (objValue == null) {
                    return;
                }
                value = objValue;
            } else {
                value = parser.longValue((Boolean)this.coerce.value());
                if (context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.fieldType().names().fullName(), parser.text(), boost);
                }
            }
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            CustomLongNumericField field = new CustomLongNumericField(value, (MappedFieldType)this.fieldType());
            field.setBoost(boost);
            fields.add(field);
        }
        if (this.fieldType().hasDocValues()) {
            this.addDocValue(context, fields, value);
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().numericPrecisionStep() != 16) {
            builder.field("precision_step", this.fieldType().numericPrecisionStep());
        }
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static class CustomLongNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final long number;

        public CustomLongNumericField(long number, MappedFieldType fieldType) {
            super(number, fieldType);
            this.number = number;
        }

        public TokenStream tokenStream(Analyzer analyzer, TokenStream previous) throws IOException {
            if (this.fieldType().indexOptions() != IndexOptions.NONE) {
                return this.getCachedStream().setLongValue(this.number);
            }
            return null;
        }

        @Override
        public String numericAsString() {
            return Long.toString(this.number);
        }
    }

    public static class LongFieldType
    extends NumberFieldMapper.NumberFieldType {
        public LongFieldType() {
            super(FieldType.NumericType.LONG);
        }

        protected LongFieldType(LongFieldType ref) {
            super(ref);
        }

        @Override
        public NumberFieldMapper.NumberFieldType clone() {
            return new LongFieldType(this);
        }

        @Override
        public String typeName() {
            return LongFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Long nullValue() {
            return (Long)super.nullValue();
        }

        @Override
        public Long value(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof BytesRef) {
                return Numbers.bytesToLong((BytesRef)value);
            }
            return Long.parseLong(value.toString());
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            BytesRefBuilder bytesRef = new BytesRefBuilder();
            NumericUtils.longToPrefixCoded((long)NumberFieldMapper.parseLongValue(value), (int)0, (BytesRefBuilder)bytesRef);
            return bytesRef.get();
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            return NumericRangeQuery.newLongRange((String)this.names().indexName(), (int)this.numericPrecisionStep(), (Long)(lowerTerm == null ? null : Long.valueOf(NumberFieldMapper.parseLongValue(lowerTerm))), (Long)(upperTerm == null ? null : Long.valueOf(NumberFieldMapper.parseLongValue(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
            long iValue = NumberFieldMapper.parseLongValue(value);
            long iSim = fuzziness.asLong();
            return NumericRangeQuery.newLongRange((String)this.names().indexName(), (int)this.numericPrecisionStep(), (Long)(iValue - iSim), (Long)(iValue + iSim), (boolean)true, (boolean)true);
        }

        @Override
        public FieldStats stats(Terms terms, int maxDoc) throws IOException {
            long minValue = NumericUtils.getMinLong((Terms)terms);
            long maxValue = NumericUtils.getMaxLong((Terms)terms);
            return new FieldStats.Long(maxDoc, terms.getDocCount(), terms.getSumDocFreq(), terms.getSumTotalTermFreq(), minValue, maxValue);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.longField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                if (propNode == null) {
                    throw new MapperParsingException("Property [null_value] cannot be null.");
                }
                builder.nullValue(XContentMapValues.nodeLongValue(propNode));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, LongFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, 16);
            this.builder = this;
        }

        public Builder nullValue(long nullValue) {
            this.fieldType.setNullValue(nullValue);
            return this;
        }

        @Override
        public LongFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            LongFieldMapper fieldMapper = new LongFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
            return (LongFieldMapper)fieldMapper.includeInAll(this.includeInAll);
        }

        @Override
        protected NamedAnalyzer makeNumberAnalyzer(int precisionStep) {
            return NumericLongAnalyzer.buildNamedAnalyzer(precisionStep);
        }

        @Override
        protected int maxPrecisionStep() {
            return 64;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final MappedFieldType FIELD_TYPE = new LongFieldType();

        static {
            FIELD_TYPE.freeze();
        }
    }
}

