/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import org.apache.lucene.search.similarities.Normalization;
import org.apache.lucene.search.similarities.NormalizationH1;
import org.apache.lucene.search.similarities.NormalizationH2;
import org.apache.lucene.search.similarities.NormalizationH3;
import org.apache.lucene.search.similarities.NormalizationZ;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.similarity.SimilarityProvider;

public abstract class AbstractSimilarityProvider
implements SimilarityProvider {
    protected static final Normalization NO_NORMALIZATION = new Normalization.NoNormalization();
    private final String name;

    protected AbstractSimilarityProvider(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    protected Normalization parseNormalization(Settings settings) {
        String normalization = settings.get("normalization");
        if ("no".equals(normalization)) {
            return NO_NORMALIZATION;
        }
        if ("h1".equals(normalization)) {
            float c = settings.getAsFloat("normalization.h1.c", Float.valueOf(1.0f)).floatValue();
            return new NormalizationH1(c);
        }
        if ("h2".equals(normalization)) {
            float c = settings.getAsFloat("normalization.h2.c", Float.valueOf(1.0f)).floatValue();
            return new NormalizationH2(c);
        }
        if ("h3".equals(normalization)) {
            float c = settings.getAsFloat("normalization.h3.c", Float.valueOf(800.0f)).floatValue();
            return new NormalizationH3(c);
        }
        if ("z".equals(normalization)) {
            float z = settings.getAsFloat("normalization.z.z", Float.valueOf(0.3f)).floatValue();
            return new NormalizationZ(z);
        }
        throw new IllegalArgumentException("Unsupported Normalization [" + normalization + "]");
    }
}

