/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class PipelineAggregatorFactory {
    protected String name;
    protected String type;
    protected String[] bucketsPaths;
    protected Map<String, Object> metaData;

    public PipelineAggregatorFactory(String name, String type, String[] bucketsPaths) {
        this.name = name;
        this.type = type;
        this.bucketsPaths = bucketsPaths;
    }

    public String name() {
        return this.name;
    }

    public final void validate(AggregatorFactory parent, AggregatorFactory[] factories, List<PipelineAggregatorFactory> pipelineAggregatorFactories) {
        this.doValidate(parent, factories, pipelineAggregatorFactories);
    }

    protected abstract PipelineAggregator createInternal(Map<String, Object> var1) throws IOException;

    public final PipelineAggregator create() throws IOException {
        PipelineAggregator aggregator = this.createInternal(this.metaData);
        return aggregator;
    }

    public void doValidate(AggregatorFactory parent, AggregatorFactory[] factories, List<PipelineAggregatorFactory> pipelineAggregatorFactories) {
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    public String getName() {
        return this.name;
    }

    public String[] getBucketsPaths() {
        return this.bucketsPaths;
    }
}

