/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.search.lookup.LeafDocLookup;
import org.elasticsearch.search.lookup.LeafFieldsLookup;
import org.elasticsearch.search.lookup.LeafIndexLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class LeafSearchLookup {
    final LeafReaderContext ctx;
    final LeafDocLookup docMap;
    final SourceLookup sourceLookup;
    final LeafFieldsLookup fieldsLookup;
    final LeafIndexLookup indexLookup;
    final ImmutableMap<String, Object> asMap;

    public LeafSearchLookup(LeafReaderContext ctx, LeafDocLookup docMap, SourceLookup sourceLookup, LeafFieldsLookup fieldsLookup, LeafIndexLookup indexLookup, Map<String, Object> topLevelMap) {
        this.ctx = ctx;
        this.docMap = docMap;
        this.sourceLookup = sourceLookup;
        this.fieldsLookup = fieldsLookup;
        this.indexLookup = indexLookup;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(topLevelMap);
        builder.put((Object)"doc", (Object)docMap);
        builder.put((Object)"_doc", (Object)docMap);
        builder.put((Object)"_source", (Object)sourceLookup);
        builder.put((Object)"_fields", (Object)fieldsLookup);
        builder.put((Object)"_index", (Object)indexLookup);
        this.asMap = builder.build();
    }

    public ImmutableMap<String, Object> asMap() {
        return this.asMap;
    }

    public SourceLookup source() {
        return this.sourceLookup;
    }

    public LeafIndexLookup indexLookup() {
        return this.indexLookup;
    }

    public LeafFieldsLookup fields() {
        return this.fieldsLookup;
    }

    public LeafDocLookup doc() {
        return this.docMap;
    }

    public void setDocument(int docId) {
        this.docMap.setDocument(docId);
        this.sourceLookup.setSegmentAndDocument(this.ctx, docId);
        this.fieldsLookup.setDocument(docId);
        this.indexLookup.setDocument(docId);
    }
}

