/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import jxl.CellType;
import jxl.LabelCell;
import jxl.StringFormulaCell;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.CellValue;
import jxl.read.biff.File;
import jxl.read.biff.Record;
import jxl.read.biff.SheetImpl;

class StringFormulaRecord
extends CellValue
implements LabelCell,
FormulaData,
StringFormulaCell {
    private String value;
    private ExternalSheet externalSheet;
    private String formulaString;
    private byte[] data;

    public StringFormulaRecord(Record t, File excelFile, FormattingRecords fr, ExternalSheet es, SheetImpl si) {
        super(t, fr, si);
        this.externalSheet = es;
        this.data = this.getRecord().getData();
        int pos = excelFile.getPos();
        Record nextRecord = excelFile.next();
        int count = 0;
        while (nextRecord.getType() != Type.STRING && count < 4) {
            nextRecord = excelFile.next();
            ++count;
        }
        Assert.verify(count < 4, " @ " + pos);
        this.readString(nextRecord.getData());
    }

    private void readString(byte[] data) {
        boolean richString;
        int pos = 0;
        int chars = IntegerHelper.getInt(data[0], data[1]);
        byte optionFlags = data[pos += 2];
        ++pos;
        if ((optionFlags & 0xF) != optionFlags) {
            pos = 0;
            chars = IntegerHelper.getInt(data[0], (byte)0);
            optionFlags = data[1];
            pos = 2;
        }
        boolean extendedString = (optionFlags & 4) != 0;
        boolean bl = richString = (optionFlags & 8) != 0;
        if (richString) {
            pos += 2;
        }
        if (extendedString) {
            pos += 4;
        }
        boolean asciiEncoding = (optionFlags & 1) == 0;
        Object bytes = null;
        this.value = asciiEncoding ? StringHelper.getString(data, chars, pos) : StringHelper.getUnicodeString(data, chars, pos);
    }

    public String getContents() {
        return this.value;
    }

    public String getString() {
        return this.value;
    }

    public CellType getType() {
        return CellType.STRING_FORMULA;
    }

    public byte[] getFormulaData() {
        return this.data;
    }

    public String getFormula() throws FormulaException {
        if (this.formulaString == null) {
            byte[] tokens = new byte[this.data.length - 22];
            System.arraycopy(this.data, 22, tokens, 0, tokens.length);
            FormulaParser fp = new FormulaParser(tokens, this, this.externalSheet);
            fp.parse();
            this.formulaString = fp.getFormula();
        }
        return this.formulaString;
    }
}

