/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SetCHARBinder;

class LittleEndianSetCHARBinder
extends SetCHARBinder {
    LittleEndianSetCHARBinder() {
    }

    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        byte[][] datums = stmt.parameterDatum[rank];
        byte[] value = datums[bindPosition];
        if (clearPriorBindValues) {
            datums[bindPosition] = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
        } else {
            bindIndicators[indoffset] = 0;
            int l = value.length;
            bindChars[charoffset] = (char)l;
            bindIndicators[lenoffset] = l > 65532 ? -2 : (short)(l + 2);
            int cpos = charoffset + (l >> 1);
            if (l % 2 == 1) {
                bindChars[cpos + 1] = (char)(value[--l] & 0xFF);
            }
            while (l > 0) {
                bindChars[cpos--] = (char)(value[l -= 2] & 0xFF | value[l + 1] << 8);
            }
        }
    }
}

