/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RawCommonAccessor;

class OutRawAccessor
extends RawCommonAccessor {
    static final int MAXLENGTH_NEW = Short.MAX_VALUE;
    static final int MAXLENGTH_OLD = Short.MAX_VALUE;

    OutRawAccessor(OracleStatement stmt, int max_len, short form, int external_type) throws SQLException {
        this.init(stmt, 23, 23, form, true);
        this.initForDataAccess(external_type, max_len, null);
    }

    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        if (external_type != 0) {
            this.externalType = external_type;
        }
        this.internalTypeMaxLength = this.statement.connection.getVersionNumber() >= 8000 ? Short.MAX_VALUE : Short.MAX_VALUE;
        if (max_len > 0 && max_len < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = max_len;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    byte[] getBytes(int currentRow) throws SQLException {
        byte[] result = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
            int off = this.columnIndex + this.byteLength * currentRow;
            result = new byte[len];
            System.arraycopy(this.rowSpaceByte, off, result, 0, len);
        }
        return result;
    }
}

