/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CNamedTypeAccessor;
import oracle.jdbc.driver.T2CResultSetAccessor;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.oracore.OracleTypeADT;

class T2CStatement
extends OracleStatement {
    T2CConnection connection = null;
    int userResultSetType = -1;
    int userResultSetConcur = -1;
    static int T2C_EXTEND_BUFFER = -3;
    long[] t2cOutput = new long[10];
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:53_PDT_2005";

    T2CStatement(T2CConnection conn, int batchValue, int rowPrefetchValue) throws SQLException {
        this(conn, batchValue, rowPrefetchValue, -1, -1);
        this.connection = conn;
    }

    T2CStatement(T2CConnection conn, int batch_value, int row_prefetch_value, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        super(conn, batch_value, row_prefetch_value, UserResultSetType, UserResultSetConcur);
        this.userResultSetType = UserResultSetType;
        this.userResultSetConcur = UserResultSetConcur;
        this.connection = conn;
    }

    static native int t2cParseExecuteDescribe(OracleStatement var0, long var1, int var3, int var4, int var5, boolean var6, boolean var7, boolean var8, boolean var9, byte[] var10, int var11, byte var12, int var13, int var14, short[] var15, int var16, byte[] var17, char[] var18, int var19, int var20, short[] var21, int var22, int var23, byte[] var24, char[] var25, int var26, int var27, int[] var28, short[] var29, byte[] var30, int var31, int var32, int var33, int var34, boolean var35, boolean var36, Accessor[] var37, byte[][][] var38, long[] var39, byte[] var40, int var41, char[] var42, int var43, short[] var44, int var45, boolean var46);

    static native int t2cDefineExecuteFetch(OracleStatement var0, long var1, int var3, int var4, int var5, int var6, boolean var7, boolean var8, byte[] var9, int var10, byte var11, int var12, int var13, short[] var14, int var15, byte[] var16, char[] var17, int var18, int var19, short[] var20, byte[] var21, int var22, int var23, boolean var24, boolean var25, Accessor[] var26, byte[][][] var27, long[] var28, byte[] var29, int var30, char[] var31, int var32, short[] var33, int var34);

    static native int t2cDescribe(long var0, short[] var2, byte[] var3, int var4, int var5, int var6, int var7);

    static native int t2cDefineFetch(long var0, int var2, short[] var3, byte[] var4, int var5, int var6, Accessor[] var7, byte[] var8, int var9, char[] var10, int var11, short[] var12, int var13, long[] var14);

    static native int t2cFetch(long var0, boolean var2, int var3, Accessor[] var4, byte[] var5, int var6, char[] var7, int var8, short[] var9, int var10, long[] var11);

    static native int t2cCloseStatement(long var0);

    static native int t2cEndToEndUpdate(long var0, byte[] var2, int var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int var9, int var10);

    static native int t2cGetRowsDmlReturned(long var0);

    static native int t2cFetchDmlReturnParams(long var0, Accessor[] var2, byte[] var3, char[] var4, short[] var5);

    String bytes2String(byte[] bytes, int offset, int size) throws SQLException {
        byte[] tmp = new byte[size];
        System.arraycopy(bytes, offset, tmp, 0, size);
        return this.connection.conversion.CharBytesToString(tmp, size);
    }

    void processDescribeData() throws SQLException {
        this.described = true;
        this.describedWithNames = true;
        if (this.accessors == null || this.numberOfDefinePositions > this.accessors.length) {
            this.accessors = new Accessor[this.numberOfDefinePositions];
        }
        int currentShort = this.connection.queryMetaData1Offset;
        int currentChar = this.connection.queryMetaData2Offset;
        short[] s = this.connection.queryMetaData1;
        byte[] c = this.connection.queryMetaData2;
        int i = 0;
        while (i < this.numberOfDefinePositions) {
            Accessor accessor;
            short accessorType = s[currentShort + 0];
            short maxLength = s[currentShort + 1];
            short maxCharLength = s[currentShort + 11];
            boolean nullable = s[currentShort + 2] != 0;
            short precision = s[currentShort + 3];
            short scale = s[currentShort + 4];
            int flags = 0;
            int contflag = 0;
            int totalElems = 0;
            short formOfUse = s[currentShort + 5];
            short columnNameLen = s[currentShort + 6];
            String columnName = this.bytes2String(c, currentChar, columnNameLen);
            short typeNameLen = s[currentShort + 12];
            String typeName = null;
            OracleTypeADT otype = null;
            currentChar += columnNameLen;
            if (typeNameLen > 0) {
                typeName = this.bytes2String(c, currentChar, typeNameLen);
                currentChar += typeNameLen;
                otype = new OracleTypeADT(typeName, (Connection)this.connection);
                otype.tdoCState = ((long)s[currentShort + 7] & 0xFFFFL) << 48 | ((long)s[currentShort + 8] & 0xFFFFL) << 32 | ((long)s[currentShort + 9] & 0xFFFFL) << 16 | (long)s[currentShort + 10] & 0xFFFFL;
            }
            if ((accessor = this.accessors[i]) != null && !accessor.useForDescribeIfPossible(accessorType, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, typeName)) {
                accessor = null;
            }
            if (accessor == null) {
                switch (accessorType) {
                    case 1: {
                        accessor = new VarcharAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        if (maxCharLength <= 0) break;
                        accessor.setDisplaySize(maxCharLength);
                        break;
                    }
                    case 96: {
                        accessor = new CharAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        if (maxCharLength <= 0) break;
                        accessor.setDisplaySize(maxCharLength);
                        break;
                    }
                    case 2: {
                        accessor = new NumberAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 23: {
                        accessor = new RawAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 100: {
                        accessor = new BinaryFloatAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 101: {
                        accessor = new BinaryDoubleAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 8: {
                        accessor = new LongAccessor(this, i + 1, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        this.rowPrefetch = 1;
                        break;
                    }
                    case 24: {
                        accessor = new LongRawAccessor(this, i + 1, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        this.rowPrefetch = 1;
                        break;
                    }
                    case 104: {
                        accessor = new RowidAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 102: 
                    case 116: {
                        accessor = new T2CResultSetAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 12: {
                        accessor = new DateAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 180: {
                        accessor = new TimestampAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 181: {
                        accessor = new TimestamptzAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 231: {
                        accessor = new TimestampltzAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 182: {
                        accessor = new IntervalymAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 183: {
                        accessor = new IntervaldsAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 112: {
                        accessor = new ClobAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 113: {
                        accessor = new BlobAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 114: {
                        accessor = new BfileAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse);
                        break;
                    }
                    case 109: {
                        accessor = new NamedTypeAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, typeName, otype);
                        break;
                    }
                    case 111: {
                        accessor = new RefTypeAccessor(this, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, typeName, otype);
                        break;
                    }
                    default: {
                        throw new SQLException("Unknown or unimplemented accessor type: " + accessorType);
                    }
                }
                this.accessors[i] = accessor;
            } else if (otype != null) {
                accessor.initMetadata();
            }
            accessor.columnName = columnName;
            ++i;
            currentShort += 13;
        }
    }

    void doDescribe(boolean includeNames) throws SQLException {
        boolean try_again;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.do_describe ( includeNames = " + includeNames + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.described) {
            return;
        }
        if (!this.isOpen) {
            DatabaseError.throwSqlException(144);
        }
        do {
            try_again = false;
            this.numberOfDefinePositions = T2CStatement.t2cDescribe(this.c_state, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size);
            if (this.numberOfDefinePositions == -1) {
                this.connection.checkError(this.numberOfDefinePositions);
            }
            if (this.numberOfDefinePositions != T2C_EXTEND_BUFFER) continue;
            try_again = true;
            this.connection.reallocateQueryMetaData(this.connection.queryMetaData1Size * 2, this.connection.queryMetaData2Size * 2);
        } while (try_again);
        this.processDescribeData();
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.do_describe returns: void", this);
            OracleLog.recursiveTrace = false;
        }
    }

    void executeForDescribe() throws SQLException {
        boolean try_again;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.execute_for_describe () ", this);
            OracleLog.recursiveTrace = false;
        }
        this.t2cOutput[0] = 0L;
        this.t2cOutput[2] = 0L;
        boolean need_to_describe = !this.described;
        boolean executed = false;
        do {
            try_again = false;
            if (this.connection.endToEndAnyChanged) {
                this.pushEndToEndValues();
                this.connection.endToEndAnyChanged = false;
            }
            byte[] array_sql = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
            int status = T2CStatement.t2cParseExecuteDescribe(this, this.c_state, this.numberOfBindPositions, 0, 0, false, this.needToParse, need_to_describe, executed, array_sql, array_sql.length, this.sqlKind, this.rowPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, this.ibtBindIndicators, this.ibtBindIndicatorOffset, this.ibtBindIndicatorSize, this.ibtBindBytes, this.ibtBindChars, this.ibtBindByteOffset, this.ibtBindCharOffset, this.returnParamMeta, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size, true, true, this.accessors, null, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.connection.plsqlCompilerWarnings);
            this.validRows = (int)this.t2cOutput[1];
            if (status == -1) {
                this.connection.checkError(status);
            } else if (status == T2C_EXTEND_BUFFER) {
                status = this.connection.queryMetaData1Size * 2;
            }
            if (this.t2cOutput[3] != 0L) {
                this.foundPlsqlCompilerWarning();
            } else if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
            }
            this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
            this.needToParse = false;
            executed = true;
            if (this.sqlKind == 0) {
                this.numberOfDefinePositions = status;
                if (this.numberOfDefinePositions <= this.connection.queryMetaData1Size) continue;
                try_again = true;
                executed = true;
                this.connection.reallocateQueryMetaData(this.numberOfDefinePositions, this.numberOfDefinePositions * 8);
                continue;
            }
            this.numberOfDefinePositions = 0;
            this.validRows = status;
        } while (try_again);
        this.processDescribeData();
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.execute_for_describe () returns: void", this);
            OracleLog.recursiveTrace = false;
        }
    }

    void pushEndToEndValues() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.pushdEndToEndValues ()", this);
            OracleLog.recursiveTrace = false;
        }
        T2CConnection c = this.connection;
        byte[] e2e_action = new byte[]{};
        byte[] e2e_clientid = new byte[]{};
        byte[] e2e_ecid = new byte[]{};
        byte[] e2e_module = new byte[]{};
        if (c.endToEndValues != null) {
            if (c.endToEndHasChanged[0]) {
                String action = c.endToEndValues[0];
                if (action != null) {
                    e2e_action = DBConversion.stringToDriverCharBytes(action, c.m_clientCharacterSet);
                }
                c.endToEndHasChanged[0] = false;
            }
            if (c.endToEndHasChanged[1]) {
                String clientid = c.endToEndValues[1];
                if (clientid != null) {
                    e2e_clientid = DBConversion.stringToDriverCharBytes(clientid, c.m_clientCharacterSet);
                }
                c.endToEndHasChanged[1] = false;
            }
            if (c.endToEndHasChanged[2]) {
                String ecid = c.endToEndValues[2];
                if (ecid != null) {
                    e2e_ecid = DBConversion.stringToDriverCharBytes(ecid, c.m_clientCharacterSet);
                }
                c.endToEndHasChanged[2] = false;
            }
            if (c.endToEndHasChanged[3]) {
                String module = c.endToEndValues[3];
                if (module != null) {
                    e2e_module = DBConversion.stringToDriverCharBytes(module, c.m_clientCharacterSet);
                }
                c.endToEndHasChanged[3] = false;
            }
            T2CStatement.t2cEndToEndUpdate(this.c_state, e2e_action, e2e_action.length, e2e_clientid, e2e_clientid.length, e2e_ecid, e2e_ecid.length, e2e_module, e2e_module.length, c.endToEndECIDSequenceNumber);
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.pushEndToEndValues() returns: void", this);
            OracleLog.recursiveTrace = false;
        }
    }

    void executeForRows(boolean executed_for_describe) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.execute_for_rows (executed_for_describe  = " + executed_for_describe + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.connection.endToEndAnyChanged) {
            this.pushEndToEndValues();
            this.connection.endToEndAnyChanged = false;
        }
        if (!executed_for_describe) {
            if (this.numberOfDefinePositions > 0) {
                this.doDefineExecuteFetch();
            } else {
                this.executeForDescribe();
            }
        } else if (this.numberOfDefinePositions > 0) {
            this.doDefineFetch();
        }
        this.needToPrepareDefineBuffer = false;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.execute_for_rows () returns: void", this);
            OracleLog.recursiveTrace = false;
        }
    }

    void setupForDefine() throws SQLException {
        short[] s = this.connection.queryMetaData1;
        int currentShort = this.connection.queryMetaData1Offset;
        int i = 0;
        while (i < this.numberOfDefinePositions) {
            Accessor currentAccessor = this.accessors[i];
            if (currentAccessor == null) {
                DatabaseError.throwSqlException(21);
            }
            s[currentShort + 0] = (short)currentAccessor.defineType;
            s[currentShort + 11] = (short)currentAccessor.charLength;
            s[currentShort + 1] = (short)currentAccessor.byteLength;
            s[currentShort + 5] = currentAccessor.formOfUse;
            if (currentAccessor.internalOtype != null) {
                long tdo = ((OracleTypeADT)currentAccessor.internalOtype).getTdoCState();
                s[currentShort + 7] = (short)((tdo & 0xFFFF000000000000L) >> 48);
                s[currentShort + 8] = (short)((tdo & 0xFFFF00000000L) >> 32);
                s[currentShort + 9] = (short)((tdo & 0xFFFF0000L) >> 16);
                s[currentShort + 10] = (short)(tdo & 0xFFFFL);
            }
            ++i;
            currentShort += 13;
        }
    }

    void doDefineFetch() throws SQLException {
        if (!this.needToPrepareDefineBuffer) {
            throw new Error("doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
        }
        this.setupForDefine();
        this.t2cOutput[2] = 0L;
        this.validRows = T2CStatement.t2cDefineFetch(this.c_state, this.rowPrefetch, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.t2cOutput);
        if (this.validRows == -1) {
            this.connection.checkError(this.validRows);
        }
        if (this.t2cOutput[2] != 0L) {
            this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
        }
    }

    void doDefineExecuteFetch() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.doDefineExecuteFetch ()", this);
            OracleLog.recursiveTrace = false;
        }
        short[] queryMetaData1 = null;
        if (this.needToPrepareDefineBuffer || this.needToParse) {
            this.setupForDefine();
            queryMetaData1 = this.connection.queryMetaData1;
        }
        this.t2cOutput[0] = 0L;
        this.t2cOutput[2] = 0L;
        byte[] array_sql = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
        this.validRows = T2CStatement.t2cDefineExecuteFetch(this, this.c_state, this.numberOfDefinePositions, this.numberOfBindPositions, 0, 0, false, this.needToParse, array_sql, array_sql.length, this.sqlKind, this.rowPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, true, true, this.accessors, null, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset);
        if (this.validRows == -1) {
            this.connection.checkError(this.validRows);
        }
        if (this.t2cOutput[2] != 0L) {
            this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
        }
        this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
        this.needToParse = false;
    }

    void fetch() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.fetch ()", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.numberOfDefinePositions > 0) {
            if (this.needToPrepareDefineBuffer) {
                this.doDefineFetch();
            } else {
                this.t2cOutput[2] = 0L;
                this.validRows = T2CStatement.t2cFetch(this.c_state, this.needToPrepareDefineBuffer, this.rowPrefetch, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.t2cOutput);
                if (this.validRows == -1) {
                    this.connection.checkError(this.validRows);
                }
                if (this.t2cOutput[2] != 0L) {
                    this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
                }
            }
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.fetch () returns: void", this);
            OracleLog.recursiveTrace = false;
        }
    }

    void doClose() throws SQLException {
        int returnCode;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.do_close ()", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.defineBytes != null) {
            this.defineBytes = null;
            this.accessorByteOffset = 0;
        }
        if (this.defineChars != null) {
            this.defineChars = null;
            this.accessorCharOffset = 0;
        }
        if (this.defineIndicators != null) {
            this.defineIndicators = null;
            this.accessorShortOffset = 0;
        }
        if ((returnCode = T2CStatement.t2cCloseStatement(this.c_state)) != 0) {
            this.connection.checkError(returnCode);
        }
        this.t2cOutput = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.do_close () returns: void", this);
            OracleLog.recursiveTrace = false;
        }
    }

    void closeQuery() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.closeQuery ()", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException exc) {
                    DatabaseError.throwSqlException(exc);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CStatement.closeQuery () returns: void", this);
            OracleLog.recursiveTrace = false;
        }
    }

    Accessor allocateAccessor(int internal_type, int external_type, int col_index, int max_len, short form, String typeName, boolean forBind) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "T2CStatement.allocateAccessor(" + internal_type + ", " + external_type + ", " + col_index + ", " + max_len + ", " + form + ", " + typeName + ", " + forBind + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (internal_type == 109) {
            if (typeName == null) {
                if (forBind) {
                    DatabaseError.throwSqlException(12, "sqlType=" + external_type);
                } else {
                    DatabaseError.throwSqlException(60, "Unable to resolve type \"null\"");
                }
            }
            T2CNamedTypeAccessor result = new T2CNamedTypeAccessor(this, typeName, form, external_type, forBind, col_index - 1);
            ((Accessor)result).initMetadata();
            return result;
        }
        if (internal_type == 116 || internal_type == 102) {
            if (forBind && typeName != null) {
                DatabaseError.throwSqlException(12, "sqlType=" + external_type);
            }
            T2CResultSetAccessor result = new T2CResultSetAccessor(this, max_len, form, external_type, forBind);
            return result;
        }
        return super.allocateAccessor(internal_type, external_type, col_index, max_len, form, typeName, forBind);
    }

    void closeUsedStreams(int columnIndex) throws SQLException {
        while (this.nextStream != null && this.nextStream.columnIndex < columnIndex) {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleLog.driverLogger.log(Level.FINER, "closeUsedStream(" + columnIndex + ") closing " + this.nextStream + " at index " + this.nextStream.columnIndex, this);
                    OracleLog.recursiveTrace = false;
                }
                this.nextStream.close();
            }
            catch (IOException exc) {
                DatabaseError.throwSqlException(exc);
            }
            this.nextStream = this.nextStream.nextStream;
        }
        if (this.nextStream != null) {
            try {
                this.nextStream.needBytes();
            }
            catch (IOException e) {
                DatabaseError.throwSqlException(e);
            }
        }
    }

    void fetchDmlReturnParams() throws SQLException {
        this.rowsDmlReturned = T2CStatement.t2cGetRowsDmlReturned(this.c_state);
        if (this.rowsDmlReturned != 0) {
            this.allocateDmlReturnStorage();
            int n = T2CStatement.t2cFetchDmlReturnParams(this.c_state, this.returnParamAccessors, this.returnParamBytes, this.returnParamChars, this.returnParamIndicators);
        }
        this.returnParamsFetched = true;
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = this.numberOfBindPositions * 5;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

