/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Timestamp;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DateCommonBinder;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;

class TimestampBinder
extends DateCommonBinder {
    Binder theTimestampCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimestampCopyingBinder;

    static void init(Binder x) {
        x.type = (short)180;
        x.bytelen = 11;
    }

    TimestampBinder() {
        TimestampBinder.init(this);
    }

    Binder copyingBinder() {
        return this.theTimestampCopyingBinder;
    }

    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        Timestamp[] timestamps = stmt.parameterTimestamp[rank];
        Timestamp value = timestamps[bindPosition];
        if (clearPriorBindValues) {
            timestamps[bindPosition] = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
        } else {
            bindIndicators[indoffset] = 0;
            TimestampBinder.setOracleHMS(TimestampBinder.setOracleCYMD(value.getTime(), bindBytes, byteoffset, stmt), bindBytes, byteoffset);
            int nanos = value.getNanos();
            if (nanos != 0) {
                TimestampBinder.setOracleNanos(nanos, bindBytes, byteoffset);
                bindIndicators[lenoffset] = (short)bytePitch;
            } else {
                bindIndicators[lenoffset] = 7;
            }
        }
    }
}

