/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheImpl;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionCacheTimeOutThread
extends Thread
implements Serializable {
    private OracleConnectionCacheImpl occi = null;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:55_PDT_2005";

    OracleConnectionCacheTimeOutThread(OracleConnectionCacheImpl occimpl) throws SQLException {
        this.occi = occimpl;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheTimeOutThread(occimpl)", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public void run() {
        block8: {
            long threadTTLTimeOut = 0L;
            long threadInactivityTimeOut = 0L;
            boolean timeToLive = true;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINE, "OracleConnectionCacheTimeOutThread:run()", this);
                OracleLog.recursiveTrace = false;
            }
            try {
                while (timeToLive) {
                    threadTTLTimeOut = this.occi.getCacheTimeToLiveTimeout();
                    if (threadTTLTimeOut > 0L) {
                        this.runTimeToLiveTimeOut(threadTTLTimeOut);
                    }
                    if ((threadInactivityTimeOut = this.occi.getCacheInactivityTimeout()) > 0L) {
                        this.runInactivityTimeOut(threadInactivityTimeOut);
                    }
                    OracleConnectionCacheTimeOutThread.sleep(this.occi.getThreadWakeUpInterval() * 1000L);
                    if (this.occi.cache != null && (threadTTLTimeOut > 0L || threadInactivityTimeOut > 0L)) continue;
                    timeToLive = false;
                }
            }
            catch (SQLException e) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheTimeOutThread.run()" + e, this);
                    OracleLog.recursiveTrace = false;
                }
            }
            catch (InterruptedException ie) {
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheTimeOutThread.run()" + ie, this);
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public void runTimeToLiveTimeOut(long threadTTLTimeOut) throws SQLException {
        long connCurrTime = 0L;
        long connStartTime = 0L;
        int activeCacheSize = 0;
        PooledConnection pooledConn = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINER, "runTimeToLiveTimeOut():timeOut=<" + threadTTLTimeOut + ">" + ", activeSize=<" + this.occi.getActiveSize() + ">", this);
            OracleLog.recursiveTrace = false;
        }
        if ((activeCacheSize = this.occi.getActiveSize()) > 0) {
            Enumeration connSet = this.occi.activeCache.keys();
            while (connSet.hasMoreElements()) {
                Connection conn;
                block14: {
                    block13: {
                        pooledConn = (PooledConnection)connSet.nextElement();
                        conn = ((OraclePooledConnection)pooledConn).getLogicalHandle();
                        if (conn != null) {
                            connStartTime = ((OracleConnection)conn).getStartTime();
                        }
                        if ((connCurrTime = System.currentTimeMillis()) - connStartTime <= threadTTLTimeOut * 1000L) continue;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheTimeOutThread.runTimeToLiveTimeOut():TTL Timeout expired... Executing cancel()/close()", this);
                            OracleLog.recursiveTrace = false;
                        }
                        try {
                            ((OracleConnection)conn).cancel();
                        }
                        catch (SQLException e) {
                            if (!TRACE || OracleLog.recursiveTrace) break block13;
                            OracleLog.recursiveTrace = true;
                            OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheTimeOutThread.runTimeToLiveTimeout()" + e, this);
                            OracleLog.recursiveTrace = false;
                        }
                    }
                    try {
                        if (!conn.getAutoCommit()) {
                            ((OracleConnection)conn).rollback();
                        }
                    }
                    catch (SQLException e) {
                        if (!TRACE || OracleLog.recursiveTrace) break block14;
                        OracleLog.recursiveTrace = true;
                        OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheTimeOutThread.runTimeToLiveTimeout(): rollback" + e, this);
                        OracleLog.recursiveTrace = false;
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    if (!TRACE || OracleLog.recursiveTrace) continue;
                    OracleLog.recursiveTrace = true;
                    OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheTimeOutThread.runTimeToLiveTimeout()" + e, this);
                    OracleLog.recursiveTrace = false;
                }
            }
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheTimeOutThread.runTimeToLiveTimeOut():activeCacheSize=" + activeCacheSize + "TTLTimeOut=" + threadTTLTimeOut, this);
            OracleLog.recursiveTrace = false;
        }
    }

    public void runInactivityTimeOut(long threadInactivityTimeOut) throws SQLException {
        block8: {
            long lastAccessedTime = 0L;
            long currentTime = 0L;
            long timeOut = threadInactivityTimeOut * 1000L;
            OraclePooledConnection pooledConn = null;
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheTimeOutThread.runInactivityTimeOut():threadInactivityTimeOut=" + threadInactivityTimeOut, this);
                OracleLog.recursiveTrace = false;
            }
            try {
                if (this.occi.cache != null && this.occi.cache.size() > 0 && this.occi.cacheSize > this.occi._MIN_LIMIT) {
                    Enumeration pooledConnSet = this.occi.cache.elements();
                    while (this.occi.cacheSize > this.occi._MIN_LIMIT && pooledConnSet.hasMoreElements()) {
                        pooledConn = (OraclePooledConnection)pooledConnSet.nextElement();
                        lastAccessedTime = pooledConn.getLastAccessedTime();
                        currentTime = System.currentTimeMillis();
                        if (currentTime - lastAccessedTime <= timeOut) continue;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheTimeOutThread.runInactivityTimeOut():PooledConnection in cache closed:" + pooledConn, this);
                            OracleLog.recursiveTrace = false;
                        }
                        try {
                            this.occi.closeSingleConnection(pooledConn, false);
                        }
                        catch (SQLException ea) {
                            if (!TRACE || OracleLog.recursiveTrace) continue;
                            OracleLog.recursiveTrace = true;
                            OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheTimeOutThread.runInactivityTimeout()" + ea, this);
                            OracleLog.recursiveTrace = false;
                        }
                    }
                }
            }
            catch (NoSuchElementException ne) {
                if (!TRACE || OracleLog.recursiveTrace) break block8;
                OracleLog.recursiveTrace = true;
                OracleLog.poolLogger.log(Level.FINER, "OracleConnectionCacheTimeOutThread.runInactivityTimeOut()" + ne, this);
                OracleLog.recursiveTrace = false;
            }
        }
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleConnectionCacheTimeOutThread"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

