/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.Connection;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAHeteroResource
extends OracleXAResource {
    private int rmid = -1;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:56_PDT_2005";

    public OracleXAHeteroResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "oracle.jdbc.xa.client.OracleXAHeteroResource(pm_conn = " + pm_conn + ", xaconn = " + xaconn + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.connection = pm_conn;
        this.xaconnection = xaconn;
        if (this.connection == null) {
            throw new XAException(-7);
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.INFO, "OracleXAHeteroResource.start(xid = " + xid + ", flags = " + flags + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (xid == null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.SEVERE, "OracleXAHeteroResource.start(): XAER_INVAL: xid is null", this);
                OracleLog.recursiveTrace = false;
            }
            throw new XAException(-5);
        }
        int isolFlag = flags & 0xFF00;
        if (((flags &= 0xFFFF00FF) & 0x8200002) != flags) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.SEVERE, "OracleXAHeteroResource.start(): XAER_INVAL: invalid flag", this);
                OracleLog.recursiveTrace = false;
            }
            throw new XAException(-5);
        }
        if ((isolFlag & 0xFF00) != 0 && isolFlag != 256 && isolFlag != 512 && isolFlag != 1024) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.SEVERE, "OracleXAHeteroResource.start():XAER_INVAL: invalid Isolation flag", this);
                OracleLog.recursiveTrace = false;
            }
            throw new XAException(-5);
        }
        if ((isolFlag & 0xFF00) != 0 && (flags & 0x8200000) != 0) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.SEVERE, "OracleXAHeteroResource.start(): XAER_INVAL: Isolation flags not allowed for JOIN/RESUME", this);
                OracleLog.recursiveTrace = false;
            }
            throw new XAException(-5);
        }
        try {
            this.saveAndAlterAutoCommitModeForGlobalTransaction();
            int formatId = xid.getFormatId();
            byte[] gTrid = xid.getGlobalTransactionId();
            byte[] bQual = xid.getBranchQualifier();
            int status = this.doXaStart(formatId, gTrid, bQual, this.rmid, flags |= isolFlag, 0);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.FINER, "OracleXAHeteroResource.start(): return status = " + status, this);
                OracleLog.recursiveTrace = false;
            }
            this.checkStatus(status);
            super.push(xid);
        }
        catch (XAException ea) {
            this.restoreAutoCommitModeForGlobalTransaction();
            throw ea;
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroResource.start() return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flag) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.INFO, "OracleXAHeteroResource.end(xid = " + xid + ", flag = " + flag + ")", this);
            OracleLog.recursiveTrace = false;
        }
        try {
            if (xid == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleLog.xaLogger.log(Level.SEVERE, "OracleXAHeteroResource.end(): XAER_INVAL: xid is null", this);
                    OracleLog.recursiveTrace = false;
                }
                throw new XAException(-5);
            }
            if (flag != 0x2000000 && flag != 0x4000000 && flag != 0x20000000 && (flag & 2) != 2) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleLog.xaLogger.log(Level.SEVERE, "OracleXAHeteroResource.end(): XAER_INVAL: invalid flag", this);
                    OracleLog.recursiveTrace = false;
                }
                throw new XAException(-5);
            }
            int formatId = xid.getFormatId();
            byte[] gTrid = xid.getGlobalTransactionId();
            byte[] bQual = xid.getBranchQualifier();
            Xid stackedXid = super.suspendStacked(xid, flag);
            super.pop();
            int status = this.doXaEnd(formatId, gTrid, bQual, this.rmid, flag, 0);
            super.resumeStacked(stackedXid);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.FINER, "OracleXAHeteroResource.end(): return status = " + status, this);
                OracleLog.recursiveTrace = false;
            }
            this.checkStatus(status);
        }
        finally {
            this.restoreAutoCommitModeForGlobalTransaction();
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroResource.end() return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.INFO, "OracleXAHeteroResource.commit(xid = " + xid + ", onePhase = " + onePhase + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (xid == null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.SEVERE, "OracleXAHeteroResource.commit(): XAER_INVAL: xid is null", this);
                OracleLog.recursiveTrace = false;
            }
            throw new XAException(-5);
        }
        int flags = onePhase ? 0x40000000 : 0;
        int formatId = xid.getFormatId();
        byte[] gTrid = xid.getGlobalTransactionId();
        byte[] bQual = xid.getBranchQualifier();
        Xid stackedXid = super.suspendStacked(xid);
        int status = this.doXaCommit(formatId, gTrid, bQual, this.rmid, flags, 0);
        super.resumeStacked(stackedXid);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINER, "OracleXAHeteroResource.commit(): return status = " + status, this);
            OracleLog.recursiveTrace = false;
        }
        this.checkStatus(status);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroResource.commit() return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.INFO, "OracleXAHeteroResource.prepare(xid = " + xid + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (xid == null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.SEVERE, "OracleXAHeteroResource.prepare(): XAER_INVAL: xid is null", this);
                OracleLog.recursiveTrace = false;
            }
            throw new XAException(-5);
        }
        int formatId = xid.getFormatId();
        byte[] gTrid = xid.getGlobalTransactionId();
        byte[] bQual = xid.getBranchQualifier();
        Xid stackedXid = super.suspendStacked(xid);
        int status = this.doXaPrepare(formatId, gTrid, bQual, this.rmid, 0, 0);
        super.resumeStacked(stackedXid);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINER, "OracleXAHeteroResource.prepare(): return status = " + status, this);
            OracleLog.recursiveTrace = false;
        }
        if (status != 0 && status != 3) {
            this.checkStatus(status);
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroResource.prepare() return: " + status, this);
            OracleLog.recursiveTrace = false;
        }
        return status;
    }

    public void forget(Xid xid) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.INFO, "OracleXAHeteroResource.forget(xid = " + xid + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (xid == null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.SEVERE, "OracleXAHeteroResource.forget(): XAER_INVAL: xid is null", this);
                OracleLog.recursiveTrace = false;
            }
            throw new XAException(-5);
        }
        int formatId = xid.getFormatId();
        byte[] gTrid = xid.getGlobalTransactionId();
        byte[] bQual = xid.getBranchQualifier();
        int status = this.doXaForget(formatId, gTrid, bQual, this.rmid, 0, 0);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINER, "OracleXAHeteroResource.forget(): return status = " + status, this);
            OracleLog.recursiveTrace = false;
        }
        this.checkStatus(status);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroResource.forget() return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.INFO, "OracleXAHeteroResource.rollback(xid = " + xid + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (xid == null) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.xaLogger.log(Level.SEVERE, "OracleXAHeteroResource.rollback(): XAER_INVAL: xid is null", this);
                OracleLog.recursiveTrace = false;
            }
            throw new XAException(-5);
        }
        int formatId = xid.getFormatId();
        byte[] gTrid = xid.getGlobalTransactionId();
        byte[] bQual = xid.getBranchQualifier();
        Xid stackedXid = super.suspendStacked(xid);
        int status = this.doXaRollback(formatId, gTrid, bQual, this.rmid, 0, 0);
        super.resumeStacked(stackedXid);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINER, "OracleXAHeteroResource.rollback(): return status = " + status, this);
            OracleLog.recursiveTrace = false;
        }
        this.checkStatus(status);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroResource.rollback() return", this);
            OracleLog.recursiveTrace = false;
        }
    }

    private native int doXaStart(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaEnd(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaCommit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaPrepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaForget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int doXaRollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    synchronized void setRmid(int rmid) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroResource.setRmid(rmid = " + rmid + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.rmid = rmid;
    }

    synchronized int getRmid() {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroResource.getRmid() return: " + this.rmid, this);
            OracleLog.recursiveTrace = false;
        }
        return this.rmid;
    }

    private static byte[] getSerializedBytes(Xid xid) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroResource.getSerializedBytes(xid = " + xid + ")");
            OracleLog.recursiveTrace = false;
        }
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private void checkStatus(int status) throws XAException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.xaLogger.log(Level.FINE, "OracleXAHeteroResource.checkStatus(status = " + status + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (status != 0) {
            throw new XAException(status);
        }
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXAHeteroResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

