/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.history;

import java.lang.annotation.Annotation;
import org.joda.time.DateTime;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.data.util.AnnotationDetectionFieldCallback;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class AnnotationRevisionMetadata<N extends Number>
implements RevisionMetadata<N> {
    private final Object entity;
    private final N revisionNumber;
    private final DateTime revisionDate;

    public AnnotationRevisionMetadata(Object entity, Class<? extends Annotation> revisionNumberAnnotation, Class<? extends Annotation> revisionTimeStampAnnotation) {
        Assert.notNull((Object)entity);
        this.entity = entity;
        if (revisionNumberAnnotation != null) {
            AnnotationDetectionFieldCallback numberCallback = new AnnotationDetectionFieldCallback(revisionNumberAnnotation);
            ReflectionUtils.doWithFields(entity.getClass(), (ReflectionUtils.FieldCallback)numberCallback);
            this.revisionNumber = (Number)numberCallback.getValue(entity);
        } else {
            this.revisionNumber = null;
        }
        if (revisionTimeStampAnnotation != null) {
            AnnotationDetectionFieldCallback revisionCallback = new AnnotationDetectionFieldCallback(revisionTimeStampAnnotation);
            ReflectionUtils.doWithFields(entity.getClass(), (ReflectionUtils.FieldCallback)revisionCallback);
            this.revisionDate = new DateTime(revisionCallback.getValue(entity));
        } else {
            this.revisionDate = null;
        }
    }

    @Override
    public N getRevisionNumber() {
        return this.revisionNumber;
    }

    @Override
    public DateTime getRevisionDate() {
        return this.revisionDate;
    }

    @Override
    public <T> T getDelegate() {
        return (T)this.entity;
    }
}

