/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.annotations.JSON;

public class JSONPopulator {
    private static final Logger LOG = LoggerFactory.getLogger(JSONPopulator.class);
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss";

    public JSONPopulator() {
    }

    public JSONPopulator(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void populateObject(Object object, Map elements) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, IntrospectionException, IllegalArgumentException, JSONException, InstantiationException {
        Class<?> clazz = object.getClass();
        BeanInfo info = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] props = info.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            JSON json;
            PropertyDescriptor prop = props[i];
            String name = prop.getName();
            if (!elements.containsKey(name)) continue;
            Object value = elements.get(name);
            Method method = prop.getWriteMethod();
            if (method == null || (json = method.getAnnotation(JSON.class)) != null && !json.deserialize() || !Modifier.isPublic(method.getModifiers())) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            Type[] genericTypes = method.getGenericParameterTypes();
            if (paramTypes.length != 1) continue;
            Object convertedValue = this.convert(paramTypes[0], genericTypes[0], value, method);
            method.invoke(object, convertedValue);
        }
    }

    public Object convert(Class clazz, Type type, Object value, Method method) throws IllegalArgumentException, JSONException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IntrospectionException {
        if (value == null) {
            return clazz.isPrimitive() ? this.convertPrimitive(clazz, value, method) : null;
        }
        if (JSONPopulator.isJSONPrimitive(clazz)) {
            return this.convertPrimitive(clazz, value, method);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return this.convertToCollection(clazz, type, value, method);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.convertToMap(clazz, type, value, method);
        }
        if (clazz.isArray()) {
            return this.convertToArray(clazz, type, value, method);
        }
        if (value instanceof Map) {
            Object convertedValue = clazz.newInstance();
            this.populateObject(convertedValue, (Map)value);
            return convertedValue;
        }
        if (BigDecimal.class.equals((Object)clazz)) {
            return new BigDecimal(value != null ? value.toString() : "0");
        }
        if (BigInteger.class.equals((Object)clazz)) {
            return new BigInteger(value != null ? value.toString() : "0");
        }
        throw new JSONException("Incompatible types for property " + method.getName());
    }

    private static boolean isJSONPrimitive(Class clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Date.class) || clazz.equals(Boolean.class) || clazz.equals(Byte.class) || clazz.equals(Character.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Short.class) || clazz.equals(Locale.class) || clazz.isEnum();
    }

    private Object convertToArray(Class clazz, Type type, Object value, Method accessor) throws JSONException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IntrospectionException {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            Class<?> arrayType = clazz.getComponentType();
            List values = (List)value;
            Object newArray = Array.newInstance(arrayType, values.size());
            for (int j = 0; j < values.size(); ++j) {
                Object listValue = values.get(j);
                if (arrayType.equals(Object.class)) {
                    Array.set(newArray, j, listValue);
                    continue;
                }
                if (JSONPopulator.isJSONPrimitive(arrayType)) {
                    Array.set(newArray, j, this.convertPrimitive(arrayType, listValue, accessor));
                    continue;
                }
                if (listValue instanceof Map) {
                    Object newObject = null;
                    if (Map.class.isAssignableFrom(arrayType)) {
                        newObject = this.convertToMap(arrayType, type, listValue, accessor);
                    } else if (List.class.isAssignableFrom(arrayType)) {
                        newObject = this.convertToCollection(arrayType, type, listValue, accessor);
                    } else {
                        newObject = arrayType.newInstance();
                        this.populateObject(newObject, (Map)listValue);
                    }
                    Array.set(newArray, j, newObject);
                    continue;
                }
                throw new JSONException("Incompatible types for property " + accessor.getName());
            }
            return newArray;
        }
        throw new JSONException("Incompatible types for property " + accessor.getName());
    }

    private Object convertToCollection(Class clazz, Type type, Object value, Method accessor) throws JSONException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IntrospectionException {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            Class itemClass = Object.class;
            Type itemType = null;
            if (type != null && type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                itemType = ptype.getActualTypeArguments()[0];
                itemClass = itemType.getClass().equals(Class.class) ? (Class)itemType : (Class)((ParameterizedType)itemType).getRawType();
            }
            List values = (List)value;
            AbstractCollection newCollection = null;
            try {
                newCollection = (HashSet)clazz.newInstance();
            }
            catch (InstantiationException ex) {
                newCollection = Set.class.isAssignableFrom(clazz) ? new HashSet() : new ArrayList();
            }
            for (int j = 0; j < values.size(); ++j) {
                Object newObject;
                Object listValue = values.get(j);
                if (itemClass.equals(Object.class)) {
                    newCollection.add(listValue);
                    continue;
                }
                if (JSONPopulator.isJSONPrimitive(itemClass)) {
                    newCollection.add(this.convertPrimitive(itemClass, listValue, accessor));
                    continue;
                }
                if (Map.class.isAssignableFrom(itemClass)) {
                    newObject = this.convertToMap(itemClass, itemType, listValue, accessor);
                    newCollection.add(newObject);
                    continue;
                }
                if (List.class.isAssignableFrom(itemClass)) {
                    newObject = this.convertToCollection(itemClass, itemType, listValue, accessor);
                    newCollection.add(newObject);
                    continue;
                }
                if (listValue instanceof Map) {
                    newObject = itemClass.newInstance();
                    this.populateObject(newObject, (Map)listValue);
                    newCollection.add(newObject);
                    continue;
                }
                throw new JSONException("Incompatible types for property " + accessor.getName());
            }
            return newCollection;
        }
        throw new JSONException("Incompatible types for property " + accessor.getName());
    }

    private Object convertToMap(Class clazz, Type type, Object value, Method accessor) throws JSONException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, IntrospectionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            Class itemClass = Object.class;
            Type itemType = null;
            if (type != null && type instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type;
                itemType = ptype.getActualTypeArguments()[1];
                itemClass = itemType.getClass().equals(Class.class) ? (Class)itemType : (Class)((ParameterizedType)itemType).getRawType();
            }
            Map values = (Map)value;
            HashMap<String, Object> newMap = null;
            try {
                newMap = (HashMap<String, Object>)clazz.newInstance();
            }
            catch (InstantiationException ex) {
                newMap = new HashMap<String, Object>();
            }
            for (Map.Entry entry : values.entrySet()) {
                Object newObject;
                String key = (String)entry.getKey();
                Object v = entry.getValue();
                if (itemClass.equals(Object.class)) {
                    newMap.put(key, v);
                    continue;
                }
                if (JSONPopulator.isJSONPrimitive(itemClass)) {
                    newMap.put(key, this.convertPrimitive(itemClass, v, accessor));
                    continue;
                }
                if (Map.class.isAssignableFrom(itemClass)) {
                    newObject = this.convertToMap(itemClass, itemType, v, accessor);
                    newMap.put(key, newObject);
                    continue;
                }
                if (List.class.isAssignableFrom(itemClass)) {
                    newObject = this.convertToCollection(itemClass, itemType, v, accessor);
                    newMap.put(key, newObject);
                    continue;
                }
                if (v instanceof Map) {
                    newObject = itemClass.newInstance();
                    this.populateObject(newObject, (Map)v);
                    newMap.put(key, newObject);
                    continue;
                }
                throw new JSONException("Incompatible types for property " + accessor.getName());
            }
            return newMap;
        }
        throw new JSONException("Incompatible types for property " + accessor.getName());
    }

    private Object convertPrimitive(Class clazz, Object value, Method method) throws JSONException {
        if (value == null) {
            if (Short.TYPE.equals(clazz) || Short.class.equals((Object)clazz)) {
                return (short)0;
            }
            if (Byte.TYPE.equals(clazz) || Byte.class.equals((Object)clazz)) {
                return (byte)0;
            }
            if (Integer.TYPE.equals(clazz) || Integer.class.equals((Object)clazz)) {
                return 0;
            }
            if (Long.TYPE.equals(clazz) || Long.class.equals((Object)clazz)) {
                return 0L;
            }
            if (Float.TYPE.equals(clazz) || Float.class.equals((Object)clazz)) {
                return Float.valueOf(0.0f);
            }
            if (Double.TYPE.equals(clazz) || Double.class.equals((Object)clazz)) {
                return 0.0;
            }
            if (Boolean.TYPE.equals(clazz) || Boolean.class.equals((Object)clazz)) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (Short.TYPE.equals(clazz)) {
                return number.shortValue();
            }
            if (Short.class.equals((Object)clazz)) {
                return new Short(number.shortValue());
            }
            if (Byte.TYPE.equals(clazz)) {
                return number.byteValue();
            }
            if (Byte.class.equals((Object)clazz)) {
                return new Byte(number.byteValue());
            }
            if (Integer.TYPE.equals(clazz)) {
                return number.intValue();
            }
            if (Integer.class.equals((Object)clazz)) {
                return new Integer(number.intValue());
            }
            if (Long.TYPE.equals(clazz)) {
                return number.longValue();
            }
            if (Long.class.equals((Object)clazz)) {
                return new Long(number.longValue());
            }
            if (Float.TYPE.equals(clazz)) {
                return Float.valueOf(number.floatValue());
            }
            if (Float.class.equals((Object)clazz)) {
                return new Float(number.floatValue());
            }
            if (Double.TYPE.equals(clazz)) {
                return number.doubleValue();
            }
            if (Double.class.equals((Object)clazz)) {
                return new Double(number.doubleValue());
            }
            if (String.class.equals((Object)clazz)) {
                return value.toString();
            }
        } else {
            if (clazz.equals(Date.class)) {
                try {
                    JSON json = method.getAnnotation(JSON.class);
                    SimpleDateFormat formatter = new SimpleDateFormat(json != null && json.format().length() > 0 ? json.format() : this.dateFormat);
                    return formatter.parse((String)value);
                }
                catch (ParseException e) {
                    LOG.error(e.getMessage(), (Throwable)e, new String[0]);
                    throw new JSONException("Unable to parse date from: " + value);
                }
            }
            if (clazz.isEnum()) {
                String sValue = (String)value;
                return Enum.valueOf(clazz, sValue);
            }
            if (value instanceof String) {
                String sValue = (String)value;
                if (Boolean.TYPE.equals(clazz)) {
                    return Boolean.parseBoolean(sValue);
                }
                if (Boolean.class.equals((Object)clazz)) {
                    return Boolean.valueOf(sValue);
                }
                if (Short.TYPE.equals(clazz)) {
                    return Short.parseShort(sValue);
                }
                if (Short.class.equals((Object)clazz)) {
                    return Short.valueOf(sValue);
                }
                if (Byte.TYPE.equals(clazz)) {
                    return Byte.parseByte(sValue);
                }
                if (Byte.class.equals((Object)clazz)) {
                    return Byte.valueOf(sValue);
                }
                if (Integer.TYPE.equals(clazz)) {
                    return Integer.parseInt(sValue);
                }
                if (Integer.class.equals((Object)clazz)) {
                    return Integer.valueOf(sValue);
                }
                if (Long.TYPE.equals(clazz)) {
                    return Long.parseLong(sValue);
                }
                if (Long.class.equals((Object)clazz)) {
                    return Long.valueOf(sValue);
                }
                if (Float.TYPE.equals(clazz)) {
                    return Float.valueOf(Float.parseFloat(sValue));
                }
                if (Float.class.equals((Object)clazz)) {
                    return Float.valueOf(sValue);
                }
                if (Double.TYPE.equals(clazz)) {
                    return Double.parseDouble(sValue);
                }
                if (Double.class.equals((Object)clazz)) {
                    return Double.valueOf(sValue);
                }
                if (Character.TYPE.equals(clazz) || Character.class.equals((Object)clazz)) {
                    char charValue = '\u0000';
                    if (sValue.length() > 0) {
                        charValue = sValue.charAt(0);
                    }
                    if (Character.TYPE.equals(clazz)) {
                        return Character.valueOf(charValue);
                    }
                    return new Character(charValue);
                }
                if (clazz.equals(Locale.class)) {
                    String[] components = sValue.split("_", 2);
                    if (components.length == 2) {
                        return new Locale(components[0], components[1]);
                    }
                    return new Locale(sValue);
                }
                if (Enum.class.isAssignableFrom(clazz)) {
                    return Enum.valueOf(clazz, sValue);
                }
            }
        }
        return value;
    }
}

