/*
 * Decompiled with CFR 0.152.
 */
package com.common.unique;

import com.common.unique.SingleSequence;
import com.coreframework.db.DatabaseEnum;
import java.util.HashMap;

public class SequenceFactory {
    private static HashMap sequenceMap;
    private static SequenceFactory factory;

    static {
        factory = new SequenceFactory();
    }

    private SequenceFactory() {
        sequenceMap = new HashMap();
    }

    public static SingleSequence getSequence(String name, DatabaseEnum serverName) throws Exception {
        SingleSequence sequence = (SingleSequence)sequenceMap.get(name);
        if (sequence == null) {
            return factory.createSequence(sequenceMap, name, serverName);
        }
        return sequence;
    }

    private synchronized SingleSequence createSequence(HashMap sequenceMap, String name, DatabaseEnum serverName) throws Exception {
        SingleSequence sequence = (SingleSequence)sequenceMap.get(name);
        if (sequence != null) {
            return sequence;
        }
        sequence = new SingleSequence(name, serverName);
        sequence.getNextVal();
        sequenceMap.put(name, sequence);
        return sequence;
    }
}

