/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db;

import com.coreframework.db.AbstractSqlParameterSource;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class BeanPropertySqlParameterSource
extends AbstractSqlParameterSource {
    private static final PropertyUtilsBean pu = BeanUtilsBean.getInstance().getPropertyUtils();
    private String[] propertyNames;
    private Object object;

    public BeanPropertySqlParameterSource(Object object) {
        this.object = object;
    }

    @Override
    public boolean hasValue(String paramName) {
        return pu.isReadable(this.object, paramName);
    }

    @Override
    public Object getValue(String paramName) throws IllegalArgumentException {
        try {
            return pu.getProperty(this.object, paramName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String[] getReadablePropertyNames() {
        if (this.propertyNames == null) {
            PropertyDescriptor[] props;
            ArrayList<String> names = new ArrayList<String>();
            PropertyDescriptor[] apropertydescriptor = props = pu.getPropertyDescriptors(this.object.getClass());
            int j = props.length;
            int i = 0;
            while (i < j) {
                PropertyDescriptor pd = apropertydescriptor[i];
                if (pu.isReadable(this.object, pd.getName())) {
                    names.add(pd.getName());
                }
                ++i;
            }
            this.propertyNames = names.toArray(new String[names.size()]);
        }
        return this.propertyNames;
    }

    @Override
    public int getSqlType(String paramName) {
        int sqlType = super.getSqlType(paramName);
        return sqlType;
    }
}

