/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.openplatform.service;

import com.yihu.openplatform.service.MessagePool;
import com.yihu.openplatform.service.SignAndPost;
import com.yihu.openplatform.service.UrlCheck;
import com.yihu.openplatform.utils.DictConfigUtil;
import com.yihu.openplatform.utils.SecretUtil;
import com.yihu.openplatform.vo.DictWayOperator;
import com.yihu.openplatform.vo.DictWayOperatorPushConfig;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.codec.digest.DigestUtils;

public class AppKeyService
extends TimerTask {
    public static String version = "2.5.4";
    public static boolean isDebug = false;
    private static Map<String, DictWayOperator> appkeys = null;
    private static boolean isFirstLoad = true;
    private static long reflashTime = 300000L;
    public static int tryTime = 3;
    public static final String ZK_DICTWAY_OPERATOR_ROOT_PATH = "/DictWayOperator";

    public static boolean isDebug() {
        return isDebug;
    }

    public static void setDebug(boolean isDebug) {
        AppKeyService.isDebug = isDebug;
    }

    public static Map<String, DictWayOperator> getAllAppInfo() {
        return appkeys;
    }

    public static DictWayOperator getAppInfo(String appId) {
        return appkeys.get(appId);
    }

    public static String getSecret(String appId) {
        DictWayOperator dictWayOperator = appkeys.get(appId);
        if (dictWayOperator == null) {
            return null;
        }
        return dictWayOperator.getEncryptType() != null && dictWayOperator.getEncryptType().equals("AES") ? dictWayOperator.getEncodingAESKey() : dictWayOperator.getSecret();
    }

    public static String getName(String appId) {
        DictWayOperator dictWayOperator = appkeys.get(appId);
        if (dictWayOperator == null) {
            return null;
        }
        return dictWayOperator.getOperatorName();
    }

    public static String getUrl(String appId) {
        DictWayOperator dictWayOperator = appkeys.get(appId);
        if (dictWayOperator == null) {
            return null;
        }
        return dictWayOperator.getUrl();
    }

    private static synchronized void LoadAllAppKey() {
        HashMap<String, DictWayOperator> nowAppkeys = new HashMap<String, DictWayOperator>();
        ZkClient newzk = null;
        try {
            newzk = new ZkClient(DictConfigUtil.getInstance().getCenterServerUrl(), 30000);
            String result = (String)newzk.readData(ZK_DICTWAY_OPERATOR_ROOT_PATH);
            JSONObject resultJson = JSONObject.fromObject((Object)result);
            if (resultJson.containsKey((Object)"Code") && resultJson.getInt("Code") == 10000 && resultJson.containsKey((Object)"Result")) {
                JSONArray arr = resultJson.getJSONArray("Result");
                int i = 0;
                while (i < arr.size()) {
                    try {
                        JSONObject obj = arr.getJSONObject(i);
                        DictWayOperator dictWayOperator = new DictWayOperator();
                        dictWayOperator.setOperatorID(obj.getInt("operatorid"));
                        dictWayOperator.setOperatorName(obj.containsKey((Object)"operatorName") ? obj.getString("operatorName") : "");
                        dictWayOperator.setSecret(obj.containsKey((Object)"secret") ? obj.getString("secret") : "");
                        dictWayOperator.setEncryptType(obj.containsKey((Object)"encryptType") ? obj.getString("encryptType") : "");
                        dictWayOperator.setEncodingAESKey(obj.containsKey((Object)"encodingAESKey") ? obj.getString("encodingAESKey") : "");
                        if (dictWayOperator.getSecret() != null && dictWayOperator.getSecret().length() > 0) {
                            dictWayOperator.setSecret(SecretUtil.decrypt(dictWayOperator.getSecret()));
                        }
                        if (dictWayOperator.getEncodingAESKey() != null && dictWayOperator.getEncodingAESKey().length() > 0) {
                            dictWayOperator.setEncodingAESKey(SecretUtil.decrypt(dictWayOperator.getEncodingAESKey()));
                        }
                        ArrayList<DictWayOperatorPushConfig> tmpLs = new ArrayList<DictWayOperatorPushConfig>();
                        dictWayOperator.setDictWayOperatorPushConfig(tmpLs);
                        nowAppkeys.put("" + dictWayOperator.getOperatorID(), dictWayOperator);
                        if (obj.containsKey((Object)"pushConfig") && obj.getJSONArray("pushConfig").size() > 0) {
                            JSONArray arrPushConfig = obj.getJSONArray("pushConfig");
                            int j = 0;
                            while (j < arrPushConfig.size()) {
                                JSONObject objPushConfig = arrPushConfig.getJSONObject(j);
                                if (objPushConfig.containsKey((Object)"pushtypes") && objPushConfig.containsKey((Object)"url") && objPushConfig.getString("url").length() > 0 && objPushConfig.getString("pushtypes").length() > 0) {
                                    DictWayOperatorPushConfig dictWayOperatorPushConfig = new DictWayOperatorPushConfig();
                                    dictWayOperatorPushConfig.setOperatorID(dictWayOperator.getOperatorID());
                                    dictWayOperatorPushConfig.setUrl(objPushConfig.getString("url"));
                                    dictWayOperatorPushConfig.setPushTypes(objPushConfig.getString("pushtypes"));
                                    tmpLs.add(dictWayOperatorPushConfig);
                                }
                                ++j;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            appkeys = nowAppkeys;
            return;
        }
        catch (Exception e) {
            System.out.println("load appIds fail ,please check");
            e.printStackTrace();
        }
        finally {
            try {
                if (newzk != null) {
                    newzk.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized void init(String orgClassify, int tryTime) {
        AppKeyService.init(orgClassify, tryTime, 20);
    }

    public static synchronized void init(String orgClassify, int tryTime, int threadNum) {
        if (isFirstLoad) {
            isFirstLoad = false;
            if (isDebug) {
                System.out.println("AppKeyService init");
            }
            AppKeyService.tryTime = tryTime;
            AppKeyService.LoadAllAppKey();
            Timer timer = new Timer();
            AppKeyService appKeyService = new AppKeyService();
            timer.schedule((TimerTask)appKeyService, reflashTime, reflashTime);
            System.out.println("Thread:auto reflash appIds  started  !");
            MessagePool.init(threadNum);
            UrlCheck urlCheck = new UrlCheck();
            Thread t2 = new Thread(urlCheck);
            t2.start();
            return;
        }
    }

    public static Map<String, String> postToThirdParty(String appId, Map<String, String> paramMap, String sourceAppId) throws Exception {
        HashMap<String, String> result = null;
        String msgId = "";
        DictWayOperator dictWayOperator = AppKeyService.getAppInfo(appId);
        String message = "";
        if (dictWayOperator == null) {
            result = new HashMap<String, String>();
            result.put("Message", "\u6e20\u9053\u53f7\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u63a8\u9001");
            result.put("Code", "-10000");
            if (isDebug) {
                System.out.println("appId:" + appId + "no exist ,quit send");
            }
            return result;
        }
        if (dictWayOperator.getDictWayOperatorPushConfig() == null || dictWayOperator.getDictWayOperatorPushConfig().size() == 0) {
            result = new HashMap();
            result.put("Message", "the appId\uff1a" + appId + "has none url,no push");
            result.put("Code", "-10000");
            return result;
        }
        if (paramMap.get("type") == null || paramMap.get("type").toString().length() == 0) {
            result = new HashMap();
            result.put("Message", "\u63a8\u9001\u53c2\u6570\u91cc\u9762\u6ca1\u6709type\uff0c\u65e0\u6cd5\u63a8\u9001");
            result.put("Code", "-10000");
            return result;
        }
        String secret = null;
        secret = dictWayOperator.getEncryptType() != null && dictWayOperator.getEncryptType().equals("AES") && dictWayOperator.getEncodingAESKey() != null && !dictWayOperator.getEncodingAESKey().equals("") ? dictWayOperator.getEncodingAESKey() : dictWayOperator.getSecret();
        List<DictWayOperatorPushConfig> ls = dictWayOperator.getDictWayOperatorPushConfig();
        for (DictWayOperatorPushConfig dictConfig : ls) {
            if (dictConfig.getPushTypes() != null && dictConfig.getPushTypes().indexOf("," + paramMap.get("type") + ",") >= 0) {
                msgId = MessagePool.pushMsg(dictConfig.getUrl(), appId, dictWayOperator.getOperatorName(), secret, paramMap, dictWayOperator.getEncryptType(), sourceAppId, false, false, null);
                continue;
            }
            if (!isDebug) continue;
            System.out.println("the appId\uff1a" + appId + ",url=" + dictConfig.getUrl() + ",has none pushType with :" + paramMap.get("type") + ",no push");
        }
        if (msgId != null && msgId.length() > 0) {
            result = new HashMap();
            result.put("Message", "\u5df2\u52a0\u5165\u6d88\u606f\u6c60\u4e2d");
            result.put("msgId", msgId);
            result.put("Code", "10000");
            return result;
        }
        if (isDebug) {
            System.out.println("the appId\uff1a" + appId + " ,no push");
        }
        result = new HashMap();
        result.put("Message", "\u672a\u627e\u5230\u4efb\u4f55\u8ba2\u9605\uff0c\u672a\u63a8\u9001");
        result.put("msgId", msgId);
        result.put("Code", "-10000");
        return result;
    }

    public static Map<String, String> postToThirdPartySync(String appId, Map<String, String> paramMap, String sourceAppId) throws Exception {
        HashMap<String, String> result = null;
        DictWayOperator dictWayOperator = AppKeyService.getAppInfo(appId);
        String message = "";
        if (dictWayOperator == null) {
            result = new HashMap<String, String>();
            result.put("Message", "\u6e20\u9053\u53f7\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u63a8\u9001");
            result.put("Code", "-10000");
            return result;
        }
        if (dictWayOperator.getDictWayOperatorPushConfig() == null || dictWayOperator.getDictWayOperatorPushConfig().size() == 0) {
            result = new HashMap();
            result.put("Message", "the appId\uff1a" + appId + "has none url,no push");
            result.put("Code", "-10000");
            return result;
        }
        if (paramMap.get("type") == null || paramMap.get("type").toString().length() == 0) {
            result = new HashMap();
            result.put("Message", "\u63a8\u9001\u53c2\u6570\u91cc\u9762\u6ca1\u6709type\uff0c\u65e0\u6cd5\u63a8\u9001");
            result.put("Code", "-10000");
            if (isDebug) {
                System.out.println("appId:" + appId + " none push type:" + paramMap.toString() + ",break");
            }
            return result;
        }
        String secret = null;
        secret = dictWayOperator.getEncryptType() != null && dictWayOperator.getEncryptType().equals("AES") && dictWayOperator.getEncodingAESKey() != null && !dictWayOperator.getEncodingAESKey().equals("") ? dictWayOperator.getEncodingAESKey() : dictWayOperator.getSecret();
        String returnStr = null;
        boolean isSuccess = false;
        String msgId = "";
        List<DictWayOperatorPushConfig> ls = dictWayOperator.getDictWayOperatorPushConfig();
        for (DictWayOperatorPushConfig dictConfig : ls) {
            try {
                if (dictConfig.getPushTypes() != null && dictConfig.getPushTypes().indexOf("," + paramMap.get("type") + ",") >= 0) {
                    block16: {
                        if (UrlCheck.isUrlCanUse(dictConfig.getUrl())) break block16;
                        isSuccess = false;
                        returnStr = "\u5931\u8d25\u6b21\u6570\u8fc7\u591a\uff0c\u5df2\u505c\u6b62\u63a8\u9001\uff08\u7b49url\u6062\u590d\u4e4b\u540e\uff0c\u4f1a\u81ea\u52a8\u6062\u590d\u901a\u8baf\uff09";
                        msgId = MessagePool.pushMsg(dictConfig.getUrl(), appId, dictWayOperator.getOperatorName(), secret, paramMap, dictWayOperator.getEncryptType(), sourceAppId, true, isSuccess, returnStr);
                        continue;
                    }
                    try {
                        try {
                            returnStr = SignAndPost.pushMsg(dictWayOperator.getEncryptType(), dictConfig.getUrl(), appId, secret, paramMap, sourceAppId);
                            isSuccess = true;
                        }
                        catch (Exception e) {
                            ByteArrayOutputStream buf = new ByteArrayOutputStream();
                            e.printStackTrace(new PrintWriter(buf, true));
                            String expMessage = buf.toString();
                            if (expMessage.length() > 250) {
                                expMessage = expMessage.substring(0, 250);
                            }
                            returnStr = expMessage;
                            e.printStackTrace();
                            msgId = MessagePool.pushMsg(dictConfig.getUrl(), appId, dictWayOperator.getOperatorName(), secret, paramMap, dictWayOperator.getEncryptType(), sourceAppId, true, isSuccess, returnStr);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        msgId = MessagePool.pushMsg(dictConfig.getUrl(), appId, dictWayOperator.getOperatorName(), secret, paramMap, dictWayOperator.getEncryptType(), sourceAppId, true, isSuccess, returnStr);
                        throw throwable;
                    }
                    msgId = MessagePool.pushMsg(dictConfig.getUrl(), appId, dictWayOperator.getOperatorName(), secret, paramMap, dictWayOperator.getEncryptType(), sourceAppId, true, isSuccess, returnStr);
                    continue;
                }
                if (!isDebug) continue;
                System.out.println("the appId\uff1a" + appId + ",url=" + dictConfig.getUrl() + ",has none pushType with :" + paramMap.get("type") + ",no push");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (isSuccess) {
            result = new HashMap();
            result.put("Result", returnStr);
            result.put("Message", "\u5df2\u63a8\u9001\u7ed9\u7b2c\u4e09\u65b9");
            result.put("Code", "10000");
            result.put("msgId", msgId);
        } else {
            result = new HashMap();
            result.put("Result", returnStr);
            result.put("Message", "\u63a8\u9001\u5931\u8d25");
            result.put("Code", "-10000");
        }
        return result;
    }

    public static Map<String, String> postToAllThirdParty(Map<String, String> paramMap, String sourceAppId) throws Exception {
        HashMap<String, String> result = null;
        String message = "";
        Map<String, DictWayOperator> m = AppKeyService.getAllAppInfo();
        Set<String> keys = m.keySet();
        for (String key : keys) {
            DictWayOperator dictWayOperator = m.get(key);
            try {
                AppKeyService.postToThirdParty("" + dictWayOperator.getOperatorID(), paramMap, sourceAppId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        result = new HashMap<String, String>();
        result.put("Message", "\u5df2\u52a0\u5165\u63a8\u9001\u7684\u6d88\u606f\u6c60");
        result.put("Code", "10000");
        return result;
    }

    public static Map<String, String> plaintSign(String appId, Map<String, String> oriParamMap) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        DictWayOperator dictWayOperator = AppKeyService.getAppInfo(appId);
        String message = "";
        if (dictWayOperator == null) {
            result = new HashMap();
            result.put("Message", "\u6e20\u9053\u53f7\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u751f\u6210\u7b7e\u540d");
            result.put("Code", "-10000");
            return result;
        }
        String url = dictWayOperator.getUrl() == null ? "" : dictWayOperator.getUrl();
        String secret = dictWayOperator.getSecret();
        String timestamp = Long.toString(System.currentTimeMillis());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.putAll(oriParamMap);
        String newUrl = url;
        if (url.indexOf("?") > 0) {
            newUrl = url.substring(0, url.indexOf("?"));
            String[] otherParams = url.substring(url.indexOf("?") + 1).split("&");
            int i = 0;
            while (i < otherParams.length) {
                String[] pam = otherParams[i].split("=");
                if (pam.length == 2) {
                    paramMap.put(pam[0], pam[1]);
                }
                ++i;
            }
        }
        if ("9000038".equals(appId)) {
            paramMap.put("verifyToken", SignAndPost.MD5(String.valueOf(String.valueOf(System.currentTimeMillis() / 100000L)) + "KnB2I2lkbioo"));
        }
        paramMap.put("timestamp", timestamp);
        StringBuilder stringBuilder = new StringBuilder();
        Object[] keyArray = paramMap.keySet().toArray(new String[0]);
        Arrays.sort(keyArray);
        stringBuilder.append(appId);
        Object[] objectArray = keyArray;
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            stringBuilder.append((String)key).append((String)paramMap.get(key));
            ++n2;
        }
        String codes = stringBuilder.append(secret).toString();
        DigestUtils.sha1Hex((String)"1");
        if (isDebug) {
            System.out.println("oriStr:" + codes);
        }
        String sign = DigestUtils.shaHex((String)codes).toUpperCase();
        if (isDebug) {
            System.out.println("sign=" + sign);
        }
        paramMap.put("appId", appId);
        paramMap.put("sign", sign);
        return paramMap;
    }

    @Override
    public void run() {
        AppKeyService.LoadAllAppKey();
    }
}

