/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.ArrayList;

public class GeometryCollectionMapper {
    private MapOp mapOp = null;

    public static GeometryCollection map(GeometryCollection gc, MapOp op) {
        GeometryCollectionMapper mapper = new GeometryCollectionMapper(op);
        return mapper.map(gc);
    }

    public GeometryCollectionMapper(MapOp mapOp) {
        this.mapOp = mapOp;
    }

    public GeometryCollection map(GeometryCollection gc) {
        ArrayList<Geometry> mapped = new ArrayList<Geometry>();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = this.mapOp.map(gc.getGeometryN(i));
            if (g.isEmpty()) continue;
            mapped.add(g);
        }
        return gc.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray(mapped));
    }

    public static interface MapOp {
        public Geometry map(Geometry var1);
    }
}

