/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.springframework.ws.mime.AbstractMimeMessage;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.SoapVersion;

public abstract class AbstractSoapMessage
extends AbstractMimeMessage
implements SoapMessage {
    private SoapVersion version;

    public final SoapBody getSoapBody() {
        return this.getEnvelope().getBody();
    }

    public final SoapHeader getSoapHeader() {
        return this.getEnvelope().getHeader();
    }

    public final Source getPayloadSource() {
        return this.getSoapBody().getPayloadSource();
    }

    public final Result getPayloadResult() {
        return this.getSoapBody().getPayloadResult();
    }

    public final boolean hasFault() {
        return this.getSoapBody().hasFault();
    }

    public final String getFaultReason() {
        if (this.hasFault()) {
            return this.getSoapBody().getFault().getFaultStringOrReason();
        }
        return null;
    }

    public SoapVersion getVersion() {
        if (this.version == null) {
            String envelopeNamespace = this.getEnvelope().getName().getNamespaceURI();
            if (SoapVersion.SOAP_11.getEnvelopeNamespaceUri().equals(envelopeNamespace)) {
                this.version = SoapVersion.SOAP_11;
            } else if (SoapVersion.SOAP_12.getEnvelopeNamespaceUri().equals(envelopeNamespace)) {
                this.version = SoapVersion.SOAP_12;
            } else {
                throw new IllegalStateException("Unknown Envelope namespace uri '" + envelopeNamespace + "'. " + "Cannot deduce SoapVersion.");
            }
        }
        return this.version;
    }
}

