/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.das.dbutils.handlers;

import com.coreframework.db.JDataSet;
import com.coreframework.db.QueryResult;
import com.yihu.das.dbutils.BasicRowProcessor;
import com.yihu.das.dbutils.ResultSetHandler;
import com.yihu.das.dbutils.RowProcessor;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JDataSetHandler
implements ResultSetHandler<JDataSet> {
    static final RowProcessor ROW_PROCESSOR = new BasicRowProcessor();
    private final RowProcessor convert;

    public JDataSetHandler() {
        this(ROW_PROCESSOR);
    }

    public JDataSetHandler(RowProcessor convert) {
        this.convert = convert;
    }

    @Override
    public JDataSet handle(ResultSet rs) throws SQLException {
        JDataSet jds = new JDataSet();
        try {
            int columnCount = rs.getMetaData().getColumnCount();
            String[] columnNames = new String[columnCount];
            String[] columnTypeNames = new String[columnCount];
            int i = 0;
            while (i < columnCount) {
                columnNames[i] = rs.getMetaData().getColumnName(i + 1);
                columnTypeNames[i] = rs.getMetaData().getColumnTypeName(i + 1);
                ++i;
            }
            jds.setColumnNames(columnNames);
            jds.setColumnTypeNames(columnTypeNames);
            Object[] row = null;
            while (rs.next()) {
                row = new Object[columnCount];
                int i2 = 0;
                while (i2 < columnCount) {
                    row[i2] = rs.getObject(i2 + 1) == null ? null : rs.getObject(i2 + 1);
                    ++i2;
                }
                jds.addRow(row);
            }
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
        return jds;
    }

    @Override
    public QueryResult<JDataSet> handle(ResultSet rs, int start, int pageSize) throws SQLException {
        try {
            QueryResult<JDataSet> qr = new QueryResult<JDataSet>();
            qr.setStart(start);
            qr.setPageSize(pageSize);
            int c = 0;
            if (pageSize > 1000) {
                pageSize = 1000;
            }
            if (!rs.last()) {
                return qr;
            }
            int rowCount = rs.getRow();
            if (pageSize > rowCount) {
                pageSize = rowCount;
            }
            int pageCount = (rowCount + pageSize) / pageSize;
            qr.setPageCount(pageCount);
            qr.setRowCount(rowCount);
            if (pageCount <= 0) {
                return qr;
            }
            int current = start;
            if (!rs.absolute(start == 0 ? 1 : current + 1)) {
                return qr;
            }
            JDataSet jds = new JDataSet();
            int columnCount = rs.getMetaData().getColumnCount();
            String[] columnNames = new String[columnCount];
            String[] columnTypeNames = new String[columnCount];
            int i = 0;
            while (i < columnCount) {
                columnNames[i] = rs.getMetaData().getColumnName(i + 1);
                columnTypeNames[i] = rs.getMetaData().getColumnTypeName(i + 1);
                ++i;
            }
            jds.setColumnNames(columnNames);
            jds.setColumnTypeNames(columnTypeNames);
            Object[] row = null;
            do {
                row = new Object[columnCount];
                int i2 = 0;
                while (i2 < columnCount) {
                    row[i2] = rs.getObject(i2 + 1) == null ? null : rs.getObject(i2 + 1);
                    jds.addRow(row);
                    ++i2;
                }
            } while (++c < pageSize && rs.next());
            qr.setResult(jds);
            return qr;
        }
        catch (Exception e) {
            return new QueryResult<JDataSet>(-1, e.getMessage());
        }
    }

    @Override
    public QueryResult<JDataSet> handle(ResultSet rs, int start, int pageSize, int rowCount) throws SQLException {
        return this.handle(rs, start, pageSize);
    }
}

