/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.util.Logger;

public class MSSqlServerInfo {
    private int numRetries;
    private int timeout;
    private String[] serverInfoStrings;

    public MSSqlServerInfo(String host) throws SQLException {
        block14: {
            this.numRetries = 3;
            this.timeout = 2000;
            DatagramSocket socket = null;
            InetAddress addr = InetAddress.getByName(host);
            socket = new DatagramSocket();
            byte[] msg = new byte[]{2};
            DatagramPacket p = new DatagramPacket(msg, msg.length, addr, 1434);
            socket.send(p);
            byte[] buf = new byte[4096];
            p = new DatagramPacket(buf, buf.length);
            socket.setSoTimeout(this.timeout);
            int i = 0;
            while (i < this.numRetries) {
                try {
                    socket.receive(p);
                    String infoString = MSSqlServerInfo.extractString(buf, p.getLength());
                    this.serverInfoStrings = MSSqlServerInfo.split(infoString, 59);
                    if (socket != null) {
                        socket.close();
                    }
                    return;
                }
                catch (InterruptedIOException toEx) {
                    try {
                        try {
                            if (Logger.isActive()) {
                                Logger.logException(toEx);
                            }
                            ++i;
                        }
                        catch (Exception e) {
                            if (Logger.isActive()) {
                                Logger.logException(e);
                            }
                            if (socket != null) {
                                socket.close();
                            }
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        if (socket != null) {
                            socket.close();
                        }
                        throw throwable;
                    }
                }
            }
            if (socket != null) {
                socket.close();
            }
        }
        throw new SQLException(Messages.get("error.msinfo.badinfo", host), "HY000");
    }

    public int getPortForInstance(String instanceName) throws SQLException {
        if (this.serverInfoStrings == null) {
            return -1;
        }
        if (instanceName == null || instanceName.length() == 0) {
            instanceName = "MSSQLSERVER";
        }
        String curInstance = null;
        String curPort = null;
        int index = 0;
        while (index < this.serverInfoStrings.length) {
            if (this.serverInfoStrings[index].length() == 0) {
                curInstance = null;
                curPort = null;
            } else {
                String key = this.serverInfoStrings[index];
                String value = "";
                if (++index < this.serverInfoStrings.length) {
                    value = this.serverInfoStrings[index];
                }
                if ("InstanceName".equals(key)) {
                    curInstance = value;
                }
                if ("tcp".equals(key)) {
                    curPort = value;
                }
                if (curInstance != null && curPort != null && curInstance.equalsIgnoreCase(instanceName)) {
                    try {
                        return Integer.parseInt(curPort);
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException(Messages.get("error.msinfo.badport", instanceName), "HY000");
                    }
                }
            }
            ++index;
        }
        return -1;
    }

    private static final String extractString(byte[] buf, int len) {
        int headerLength = 3;
        return new String(buf, 3, len - 3);
    }

    public static String[] split(String s, int ch) {
        int size = 0;
        int pos = 0;
        while (pos != -1) {
            pos = s.indexOf(ch, pos + 1);
            ++size;
        }
        String[] res = new String[size];
        int i = 0;
        int p1 = 0;
        int p2 = s.indexOf(ch);
        do {
            res[i++] = s.substring(p1, p2 == -1 ? s.length() : p2);
            p1 = p2 + 1;
            p2 = s.indexOf(ch, p1);
        } while (p1 != 0);
        return res;
    }
}

