/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;

public final class BooleanConverter
extends AbstractConverter {
    public static final Object NO_DEFAULT = new Object();
    private String[] trueStrings = new String[]{"true", "yes", "y", "on", "1"};
    private String[] falseStrings = new String[]{"false", "no", "n", "off", "0"};

    public BooleanConverter() {
    }

    public BooleanConverter(Object defaultValue) {
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings, Object defaultValue) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    @Override
    protected Class getDefaultType() {
        return Boolean.class;
    }

    @Override
    protected Object convertToType(Class type, Object value) throws Throwable {
        String stringValue = value.toString().toLowerCase();
        int i = 0;
        while (i < this.trueStrings.length) {
            if (this.trueStrings[i].equals(stringValue)) {
                return Boolean.TRUE;
            }
            ++i;
        }
        i = 0;
        while (i < this.falseStrings.length) {
            if (this.falseStrings[i].equals(stringValue)) {
                return Boolean.FALSE;
            }
            ++i;
        }
        throw new ConversionException("Can't convert value '" + value + "' to a Boolean");
    }

    private static String[] copyStrings(String[] src) {
        String[] dst = new String[src.length];
        int i = 0;
        while (i < src.length) {
            dst[i] = src[i].toLowerCase();
            ++i;
        }
        return dst;
    }
}

