/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.shard.ShardStateMetaData;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesListGatewayStartedShards
extends TransportNodesAction<Request, NodesGatewayStartedShards, NodeRequest, NodeGatewayStartedShards>
implements AsyncShardFetch.List<NodesGatewayStartedShards, NodeGatewayStartedShards> {
    public static final String ACTION_NAME = "internal:gateway/local/started_shards";
    private final NodeEnvironment nodeEnv;

    @Inject
    public TransportNodesListGatewayStartedShards(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeEnvironment env) {
        super(settings, ACTION_NAME, clusterName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request.class, NodeRequest.class, "fetch_shard_started");
        this.nodeEnv = env;
    }

    @Override
    public void list(ShardId shardId, IndexMetaData indexMetaData, String[] nodesIds, ActionListener<NodesGatewayStartedShards> listener) {
        this.execute(new Request(shardId, indexMetaData.getIndexUUID(), nodesIds), listener);
    }

    @Override
    protected String[] resolveNodes(Request request, ClusterState clusterState) {
        return request.nodesIds();
    }

    @Override
    protected boolean transportCompress() {
        return true;
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, Request request) {
        return new NodeRequest(nodeId, request);
    }

    @Override
    protected NodeGatewayStartedShards newNodeResponse() {
        return new NodeGatewayStartedShards();
    }

    @Override
    protected NodesGatewayStartedShards newResponse(Request request, AtomicReferenceArray responses) {
        ArrayList<NodeGatewayStartedShards> nodesList = new ArrayList<NodeGatewayStartedShards>();
        ArrayList<FailedNodeException> failures = new ArrayList<FailedNodeException>();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (resp instanceof NodeGatewayStartedShards) {
                nodesList.add((NodeGatewayStartedShards)resp);
                continue;
            }
            if (resp instanceof FailedNodeException) {
                failures.add((FailedNodeException)resp);
                continue;
            }
            this.logger.warn("unknown response type [{}], expected NodeLocalGatewayStartedShards or FailedNodeException", resp);
        }
        return new NodesGatewayStartedShards(this.clusterName, nodesList.toArray(new NodeGatewayStartedShards[nodesList.size()]), failures.toArray(new FailedNodeException[failures.size()]));
    }

    @Override
    protected NodeGatewayStartedShards nodeOperation(NodeRequest request) {
        try {
            ShardId shardId = request.getShardId();
            String indexUUID = request.getIndexUUID();
            this.logger.trace("{} loading local shard state info", shardId);
            ShardStateMetaData shardStateMetaData = ShardStateMetaData.FORMAT.loadLatestState(this.logger, this.nodeEnv.availableShardPaths(request.shardId));
            if (shardStateMetaData != null) {
                IndexMetaData metaData = this.clusterService.state().metaData().index(shardId.index().name());
                if (metaData != null) {
                    ShardPath shardPath = null;
                    try {
                        shardPath = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, metaData.getSettings());
                        if (shardPath == null) {
                            throw new IllegalStateException(shardId + " no shard path found");
                        }
                        Store.tryOpenIndex(shardPath.resolveIndex());
                    }
                    catch (Exception exception) {
                        this.logger.trace("{} can't open index for shard [{}] in path [{}]", exception, shardId, shardStateMetaData, shardPath != null ? shardPath.resolveIndex() : "");
                        return new NodeGatewayStartedShards(this.clusterService.localNode(), shardStateMetaData.version, exception);
                    }
                }
                if (!indexUUID.equals(shardStateMetaData.indexUUID) && !"_na_".equals(shardStateMetaData.indexUUID)) {
                    this.logger.warn("{} shard state info found but indexUUID didn't match expected [{}] actual [{}]", shardId, indexUUID, shardStateMetaData.indexUUID);
                } else {
                    this.logger.debug("{} shard state info found: [{}]", shardId, shardStateMetaData);
                    return new NodeGatewayStartedShards(this.clusterService.localNode(), shardStateMetaData.version);
                }
            }
            this.logger.trace("{} no local shard info found", shardId);
            return new NodeGatewayStartedShards(this.clusterService.localNode(), -1L);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to load started shards", (Throwable)e, new Object[0]);
        }
    }

    @Override
    protected boolean accumulateExceptions() {
        return true;
    }

    public static class NodeGatewayStartedShards
    extends BaseNodeResponse {
        private long version = -1L;
        private Throwable storeException = null;

        public NodeGatewayStartedShards() {
        }

        public NodeGatewayStartedShards(DiscoveryNode node, long version) {
            this(node, version, null);
        }

        public NodeGatewayStartedShards(DiscoveryNode node, long version, Throwable storeException) {
            super(node);
            this.version = version;
            this.storeException = storeException;
        }

        public long version() {
            return this.version;
        }

        public Throwable storeException() {
            return this.storeException;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.version = in.readLong();
            if (in.readBoolean()) {
                this.storeException = in.readThrowable();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.version);
            if (this.storeException != null) {
                out.writeBoolean(true);
                out.writeThrowable(this.storeException);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private ShardId shardId;
        private String indexUUID;

        public NodeRequest() {
        }

        NodeRequest(String nodeId, Request request) {
            super(request, nodeId);
            this.shardId = request.shardId();
            this.indexUUID = request.getIndexUUID();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
            this.indexUUID = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.indexUUID);
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        public String getIndexUUID() {
            return this.indexUUID;
        }
    }

    public static class NodesGatewayStartedShards
    extends BaseNodesResponse<NodeGatewayStartedShards> {
        private FailedNodeException[] failures;

        public NodesGatewayStartedShards(ClusterName clusterName, NodeGatewayStartedShards[] nodes, FailedNodeException[] failures) {
            super(clusterName, (BaseNodeResponse[])nodes);
            this.failures = failures;
        }

        @Override
        public FailedNodeException[] failures() {
            return this.failures;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.nodes = new NodeGatewayStartedShards[in.readVInt()];
            for (int i = 0; i < ((NodeGatewayStartedShards[])this.nodes).length; ++i) {
                ((NodeGatewayStartedShards[])this.nodes)[i] = new NodeGatewayStartedShards();
                ((NodeGatewayStartedShards[])this.nodes)[i].readFrom(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(((NodeGatewayStartedShards[])this.nodes).length);
            for (NodeGatewayStartedShards response : (NodeGatewayStartedShards[])this.nodes) {
                response.writeTo(out);
            }
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private ShardId shardId;
        private String indexUUID;

        public Request() {
        }

        public Request(ShardId shardId, String indexUUID, String[] nodesIds) {
            super(nodesIds);
            this.shardId = shardId;
            this.indexUUID = indexUUID;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = ShardId.readShardId(in);
            this.indexUUID = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.indexUUID);
        }

        public String getIndexUUID() {
            return this.indexUUID;
        }
    }
}

