/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import jxl.biff.DoubleHelper;
import jxl.biff.formula.NumberValue;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class DoubleValue
extends NumberValue
implements ParsedThing {
    private double value;

    public DoubleValue() {
    }

    public DoubleValue(String s) {
        try {
            this.value = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            System.err.println("Warning:  " + e.toString());
            this.value = 0.0;
        }
    }

    public int read(byte[] data, int pos) {
        this.value = DoubleHelper.getIEEEDouble(data, pos);
        return 8;
    }

    byte[] getBytes() {
        byte[] data = new byte[9];
        data[0] = Token.DOUBLE.getCode();
        DoubleHelper.getIEEEBytes(this.value, data, 1);
        return data;
    }

    public double getValue() {
        return this.value;
    }
}

