/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class SoapUtils {
    private static final Pattern ACTION_PATTERN = Pattern.compile("action\\s*=\\s*([^;]+)");

    private SoapUtils() {
    }

    public static String escapeAction(String soapAction) {
        if (!StringUtils.hasLength((String)soapAction)) {
            soapAction = "\"\"";
        }
        if (!soapAction.startsWith("\"")) {
            soapAction = "\"" + soapAction;
        }
        if (!soapAction.endsWith("\"")) {
            soapAction = soapAction + "\"";
        }
        return soapAction;
    }

    public static String extractActionFromContentType(String contentType) {
        Matcher matcher;
        if (contentType != null && (matcher = ACTION_PATTERN.matcher(contentType)).find() && matcher.groupCount() == 1) {
            return matcher.group(1).trim();
        }
        return "\"\"";
    }

    public static String setActionInContentType(String contentType, String action) {
        Assert.hasLength((String)contentType, (String)"'contentType' must not be empty");
        if (StringUtils.hasText((String)action)) {
            Matcher matcher = ACTION_PATTERN.matcher(contentType);
            if (matcher.find() && matcher.groupCount() == 1) {
                StringBuffer buffer = new StringBuffer();
                matcher.appendReplacement(buffer, "action=" + action);
                matcher.appendTail(buffer);
                return buffer.toString();
            }
            return contentType + "; action=" + action;
        }
        return contentType;
    }
}

