/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.springframework.util.Assert;
import org.springframework.ws.transport.jms.JmsTransportException;

class TextMessageInputStream
extends FilterInputStream {
    TextMessageInputStream(TextMessage message, String encoding) throws IOException {
        super(TextMessageInputStream.createInputStream(message, encoding));
    }

    private static InputStream createInputStream(TextMessage message, String encoding) throws IOException {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        Assert.notNull((Object)encoding, (String)"'encoding' must not be null");
        try {
            String text = message.getText();
            byte[] contents = text != null ? text.getBytes(encoding) : new byte[]{};
            return new ByteArrayInputStream(contents);
        }
        catch (JMSException ex) {
            throw new JmsTransportException(ex);
        }
    }
}

