/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.jave;

import it.sauronsoftware.jave.FFMPEGLocator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DefaultFFMPEGLocator
extends FFMPEGLocator {
    private static final int myEXEversion = 1;
    private String path;

    public DefaultFFMPEGLocator() {
        File dll;
        String suffix;
        File exe;
        String os = System.getProperty("os.name").toLowerCase();
        boolean isWindows = os.indexOf("windows") != -1;
        File temp = new File(System.getProperty("java.io.tmpdir"), "jave-1");
        if (!temp.exists()) {
            temp.mkdirs();
            temp.deleteOnExit();
        }
        if (!(exe = new File(temp, "ffmpeg" + (suffix = isWindows ? ".exe" : ""))).exists()) {
            this.copyFile("ffmpeg" + suffix, exe);
        }
        if (isWindows && !(dll = new File(temp, "pthreadGC2.dll")).exists()) {
            this.copyFile("pthreadGC2.dll", dll);
        }
        if (!isWindows) {
            Runtime runtime = Runtime.getRuntime();
            try {
                runtime.exec(new String[]{"/bin/chmod", "755", exe.getAbsolutePath()});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.path = exe.getAbsolutePath();
    }

    @Override
    protected String getFFMPEGExecutablePath() {
        return this.path;
    }

    private void copyFile(String path, File dest) throws RuntimeException {
        InputStream input = null;
        OutputStream output = null;
        try {
            try {
                int l;
                input = this.getClass().getResourceAsStream(path);
                output = new FileOutputStream(dest);
                byte[] buffer = new byte[1024];
                while ((l = input.read(buffer)) != -1) {
                    output.write(buffer, 0, l);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot write file " + dest.getAbsolutePath());
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Throwable throwable) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

