/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.hal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.hateoas.IanaRels;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.hal.CurieProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultCurieProvider
implements CurieProvider {
    private final Map<String, Curie> curies;
    private final Curie defaultCurie;

    public DefaultCurieProvider(String name, UriTemplate uriTemplate) {
        this(Collections.singletonMap(name, uriTemplate));
    }

    public DefaultCurieProvider(Map<String, UriTemplate> curies) {
        this(curies, null);
    }

    public DefaultCurieProvider(Map<String, UriTemplate> curies, String defaultCurieName) {
        Assert.notNull(curies, (String)"Curies must not be null!");
        HashMap<String, Curie> map = new HashMap<String, Curie>(curies.size());
        for (Map.Entry<String, UriTemplate> entry : curies.entrySet()) {
            String name = entry.getKey();
            UriTemplate template = entry.getValue();
            Assert.hasText((String)name, (String)"Curie name must not be null or empty!");
            Assert.notNull((Object)template, (String)"UriTemplate must not be null!");
            Assert.isTrue((template.getVariableNames().size() == 1 ? 1 : 0) != 0, (String)String.format("Expected a single template variable in the UriTemplate %s!", template.toString()));
            map.put(name, new Curie(name, template.toString()));
        }
        this.defaultCurie = StringUtils.hasText((String)defaultCurieName) ? (Curie)map.get(defaultCurieName) : (map.size() == 1 ? (Curie)map.values().iterator().next() : null);
        this.curies = Collections.unmodifiableMap(map);
    }

    @Override
    public Collection<? extends Object> getCurieInformation(Links links) {
        return Collections.unmodifiableCollection(this.curies.values());
    }

    @Override
    public String getNamespacedRelFrom(Link link) {
        return this.getNamespacedRelFor(link.getRel());
    }

    @Override
    public String getNamespacedRelFor(String rel) {
        boolean prefixingNeeded = this.defaultCurie != null && !IanaRels.isIanaRel(rel) && !rel.contains(":");
        return prefixingNeeded ? String.format("%s:%s", this.defaultCurie.name, rel) : rel;
    }

    protected static class Curie
    extends Link {
        private static final long serialVersionUID = 1L;
        private final String name;

        public Curie(String name, String href) {
            super(href, "curies");
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

