/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.das.dbutils;

import com.yihu.das.dbutils.AbstractQueryRunner;
import com.yihu.das.dbutils.ResultSetHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.sql.DataSource;

public class AsyncQueryRunner
extends AbstractQueryRunner {
    private final ExecutorService executorService;

    public AsyncQueryRunner(ExecutorService executorService) {
        this(null, false, executorService);
    }

    public AsyncQueryRunner(boolean pmdKnownBroken, ExecutorService executorService) {
        this(null, pmdKnownBroken, executorService);
    }

    public AsyncQueryRunner(DataSource ds, ExecutorService executorService) {
        this(ds, false, executorService);
    }

    public AsyncQueryRunner(DataSource ds, boolean pmdKnownBroken, ExecutorService executorService) {
        super(ds, pmdKnownBroken);
        this.executorService = executorService;
    }

    public Future<int[]> batch(Connection conn, String sql, Object[][] params) throws SQLException {
        return this.executorService.submit(this.batch(conn, false, sql, params));
    }

    public Future<int[]> batch(String sql, Object[][] params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.executorService.submit(this.batch(conn, true, sql, params));
    }

    private Callable<int[]> batch(Connection conn, boolean closeConn, String sql, Object[][] params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        if (params == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null parameters. If parameters aren't need, pass an empty array.");
        }
        PreparedStatement stmt = null;
        BatchCallableStatement ret = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            int i = 0;
            while (i < params.length) {
                this.fillStatement(stmt, params[i]);
                stmt.addBatch();
                ++i;
            }
            ret = new BatchCallableStatement(sql, params, conn, closeConn, stmt);
        }
        catch (SQLException e) {
            this.close(stmt);
            this.close(conn);
            this.rethrow(e, sql, (Object[])params);
        }
        return ret;
    }

    private <T> Callable<T> query(Connection conn, boolean closeConn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        PreparedStatement stmt = null;
        QueryCallableStatement<T> ret = null;
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        if (rsh == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null ResultSetHandler");
        }
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            ret = new QueryCallableStatement<T>(conn, closeConn, stmt, rsh, sql, params);
        }
        catch (SQLException e) {
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
            this.rethrow(e, sql, params);
        }
        return ret;
    }

    public <T> Future<T> query(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.executorService.submit(this.query(conn, false, sql, rsh, params));
    }

    public <T> Future<T> query(Connection conn, String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.executorService.submit(this.query(conn, false, sql, rsh, null));
    }

    public <T> Future<T> query(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.executorService.submit(this.query(conn, true, sql, rsh, params));
    }

    public <T> Future<T> query(String sql, ResultSetHandler<T> rsh) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.executorService.submit(this.query(conn, true, sql, rsh, null));
    }

    private Callable<Integer> update(Connection conn, boolean closeConn, String sql, Object ... params) throws SQLException {
        PreparedStatement stmt = null;
        UpdateCallableStatement ret = null;
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            ret = new UpdateCallableStatement(conn, closeConn, stmt, sql, params);
        }
        catch (SQLException e) {
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
            this.rethrow(e, sql, params);
        }
        return ret;
    }

    public Future<Integer> update(Connection conn, String sql) throws SQLException {
        return this.executorService.submit(this.update(conn, false, sql, null));
    }

    public Future<Integer> update(Connection conn, String sql, Object param) throws SQLException {
        return this.executorService.submit(this.update(conn, false, sql, param));
    }

    public Future<Integer> update(Connection conn, String sql, Object ... params) throws SQLException {
        return this.executorService.submit(this.update(conn, false, sql, params));
    }

    public Future<Integer> update(String sql) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.executorService.submit(this.update(conn, true, sql, null));
    }

    public Future<Integer> update(String sql, Object param) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.executorService.submit(this.update(conn, true, sql, param));
    }

    public Future<Integer> update(String sql, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.executorService.submit(this.update(conn, true, sql, params));
    }

    protected class BatchCallableStatement
    implements Callable<int[]> {
        private String sql;
        private Object[][] params;
        private Connection conn;
        private boolean closeConn;
        private PreparedStatement ps;

        public BatchCallableStatement(String sql, Object[][] params, Connection conn, boolean closeConn, PreparedStatement ps) {
            this.sql = sql;
            this.params = params;
            this.conn = conn;
            this.closeConn = closeConn;
            this.ps = ps;
        }

        @Override
        public int[] call() throws SQLException {
            int[] ret = null;
            try {
                try {
                    ret = this.ps.executeBatch();
                }
                catch (SQLException e) {
                    AsyncQueryRunner.this.rethrow(e, this.sql, (Object[])this.params);
                    AsyncQueryRunner.this.close(this.ps);
                    if (this.closeConn) {
                        AsyncQueryRunner.this.close(this.conn);
                    }
                }
            }
            finally {
                AsyncQueryRunner.this.close(this.ps);
                if (this.closeConn) {
                    AsyncQueryRunner.this.close(this.conn);
                }
            }
            return ret;
        }
    }

    protected class QueryCallableStatement<T>
    implements Callable<T> {
        private String sql;
        private Object[] params;
        private Connection conn;
        private boolean closeConn;
        private PreparedStatement ps;
        private ResultSetHandler<T> rsh;

        public QueryCallableStatement(Connection conn, boolean closeConn, PreparedStatement ps, ResultSetHandler<T> rsh, String sql, Object ... params) {
            this.sql = sql;
            this.params = params;
            this.conn = conn;
            this.closeConn = closeConn;
            this.ps = ps;
            this.rsh = rsh;
        }

        @Override
        public T call() throws SQLException {
            T ret;
            block17: {
                ResultSet rs = null;
                ret = null;
                try {
                    try {
                        rs = AsyncQueryRunner.this.wrap(this.ps.executeQuery());
                        ret = this.rsh.handle(rs);
                    }
                    catch (SQLException e) {
                        AsyncQueryRunner.this.rethrow(e, this.sql, this.params);
                        try {
                            AsyncQueryRunner.this.close(rs);
                            break block17;
                        }
                        finally {
                            AsyncQueryRunner.this.close(this.ps);
                            if (this.closeConn) {
                                AsyncQueryRunner.this.close(this.conn);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    try {
                        AsyncQueryRunner.this.close(rs);
                    }
                    finally {
                        AsyncQueryRunner.this.close(this.ps);
                        if (this.closeConn) {
                            AsyncQueryRunner.this.close(this.conn);
                        }
                    }
                    throw throwable;
                }
                try {
                    AsyncQueryRunner.this.close(rs);
                }
                finally {
                    AsyncQueryRunner.this.close(this.ps);
                    if (this.closeConn) {
                        AsyncQueryRunner.this.close(this.conn);
                    }
                }
            }
            return ret;
        }
    }

    protected class UpdateCallableStatement
    implements Callable<Integer> {
        private String sql;
        private Object[] params;
        private Connection conn;
        private boolean closeConn;
        private PreparedStatement ps;

        public UpdateCallableStatement(Connection conn, boolean closeConn, PreparedStatement ps, String sql, Object ... params) {
            this.sql = sql;
            this.params = params;
            this.conn = conn;
            this.closeConn = closeConn;
            this.ps = ps;
        }

        @Override
        public Integer call() throws SQLException {
            int rows;
            block8: {
                rows = 0;
                try {
                    try {
                        rows = this.ps.executeUpdate();
                    }
                    catch (SQLException e) {
                        AsyncQueryRunner.this.rethrow(e, this.sql, this.params);
                        AsyncQueryRunner.this.close(this.ps);
                        if (this.closeConn) {
                            AsyncQueryRunner.this.close(this.conn);
                        }
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    AsyncQueryRunner.this.close(this.ps);
                    if (this.closeConn) {
                        AsyncQueryRunner.this.close(this.conn);
                    }
                    throw throwable;
                }
                AsyncQueryRunner.this.close(this.ps);
                if (this.closeConn) {
                    AsyncQueryRunner.this.close(this.conn);
                }
            }
            return rows;
        }
    }
}

