/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.AbstractMappingContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.UrlPathHelper;

public class PathExtensionContentNegotiationStrategy
extends AbstractMappingContentNegotiationStrategy {
    private static final boolean JAF_PRESENT = ClassUtils.isPresent((String)"javax.activation.FileTypeMap", (ClassLoader)PathExtensionContentNegotiationStrategy.class.getClassLoader());
    private static final Log logger = LogFactory.getLog(PathExtensionContentNegotiationStrategy.class);
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private boolean useJaf = true;
    private boolean ignoreUnknownExtensions = true;

    public PathExtensionContentNegotiationStrategy() {
        this(null);
    }

    public PathExtensionContentNegotiationStrategy(Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
        this.urlPathHelper.setUrlDecode(false);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public void setUseJaf(boolean useJaf) {
        this.useJaf = useJaf;
    }

    public void setIgnoreUnknownExtensions(boolean ignoreUnknownExtensions) {
        this.ignoreUnknownExtensions = ignoreUnknownExtensions;
    }

    @Override
    protected String getMediaTypeKey(NativeWebRequest webRequest) {
        HttpServletRequest request = webRequest.getNativeRequest(HttpServletRequest.class);
        if (request == null) {
            logger.warn((Object)"An HttpServletRequest is required to determine the media type key");
            return null;
        }
        String path = this.urlPathHelper.getLookupPathForRequest(request);
        String extension = UriUtils.extractFileExtension(path);
        return StringUtils.hasText((String)extension) ? extension.toLowerCase(Locale.ENGLISH) : null;
    }

    @Override
    protected MediaType handleNoMatch(NativeWebRequest webRequest, String extension) throws HttpMediaTypeNotAcceptableException {
        MediaType mediaType;
        if (this.useJaf && JAF_PRESENT && (mediaType = ActivationMediaTypeFactory.getMediaType("file." + extension)) != null && !MediaType.APPLICATION_OCTET_STREAM.equals(mediaType)) {
            return mediaType;
        }
        if (this.ignoreUnknownExtensions) {
            return null;
        }
        throw new HttpMediaTypeNotAcceptableException(this.getAllMediaTypes());
    }

    public MediaType getMediaTypeForResource(Resource resource) {
        Assert.notNull((Object)resource);
        MediaType mediaType = null;
        String filename = resource.getFilename();
        String extension = StringUtils.getFilenameExtension((String)filename);
        if (extension != null) {
            mediaType = this.lookupMediaType(extension);
        }
        if (mediaType == null && JAF_PRESENT) {
            mediaType = ActivationMediaTypeFactory.getMediaType(filename);
        }
        if (MediaType.APPLICATION_OCTET_STREAM.equals(mediaType)) {
            mediaType = null;
        }
        return mediaType;
    }

    private static class ActivationMediaTypeFactory {
        private static final FileTypeMap fileTypeMap = ActivationMediaTypeFactory.initFileTypeMap();

        private ActivationMediaTypeFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static FileTypeMap initFileTypeMap() {
            ClassPathResource resource = new ClassPathResource("org/springframework/mail/javamail/mime.types");
            if (resource.exists()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Loading JAF FileTypeMap from " + resource));
                }
                InputStream inputStream = null;
                try {
                    inputStream = resource.getInputStream();
                    MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(inputStream);
                    return mimetypesFileTypeMap;
                }
                catch (IOException iOException) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Loading default Java Activation Framework FileTypeMap");
            }
            return FileTypeMap.getDefaultFileTypeMap();
        }

        public static MediaType getMediaType(String filename) {
            String mediaType = fileTypeMap.getContentType(filename);
            return StringUtils.hasText((String)mediaType) ? MediaType.parseMediaType(mediaType) : null;
        }
    }
}

