/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class GeoDistanceRangeQueryBuilder
extends QueryBuilder {
    private final String name;
    private Object from;
    private Object to;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private double lat;
    private double lon;
    private String geohash;
    private GeoDistance geoDistance;
    private String queryName;
    private String optimizeBbox;
    private Boolean coerce;
    private Boolean ignoreMalformed;

    public GeoDistanceRangeQueryBuilder(String name) {
        this.name = name;
    }

    public GeoDistanceRangeQueryBuilder point(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        return this;
    }

    public GeoDistanceRangeQueryBuilder lat(double lat) {
        this.lat = lat;
        return this;
    }

    public GeoDistanceRangeQueryBuilder lon(double lon) {
        this.lon = lon;
        return this;
    }

    public GeoDistanceRangeQueryBuilder from(Object from) {
        this.from = from;
        return this;
    }

    public GeoDistanceRangeQueryBuilder to(Object to) {
        this.to = to;
        return this;
    }

    public GeoDistanceRangeQueryBuilder gt(Object from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public GeoDistanceRangeQueryBuilder gte(Object from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public GeoDistanceRangeQueryBuilder lt(Object to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public GeoDistanceRangeQueryBuilder lte(Object to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public GeoDistanceRangeQueryBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public GeoDistanceRangeQueryBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public GeoDistanceRangeQueryBuilder geohash(String geohash) {
        this.geohash = geohash;
        return this;
    }

    public GeoDistanceRangeQueryBuilder geoDistance(GeoDistance geoDistance) {
        this.geoDistance = geoDistance;
        return this;
    }

    public GeoDistanceRangeQueryBuilder optimizeBbox(String optimizeBbox) {
        this.optimizeBbox = optimizeBbox;
        return this;
    }

    public GeoDistanceRangeQueryBuilder coerce(boolean coerce) {
        this.coerce = coerce;
        return this;
    }

    public GeoDistanceRangeQueryBuilder ignoreMalformed(boolean ignoreMalformed) {
        this.ignoreMalformed = ignoreMalformed;
        return this;
    }

    public GeoDistanceRangeQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("geo_distance_range");
        if (this.geohash != null) {
            builder.field(this.name, this.geohash);
        } else {
            builder.startArray(this.name).value(this.lon).value(this.lat).endArray();
        }
        builder.field("from", this.from);
        builder.field("to", this.to);
        builder.field("include_lower", this.includeLower);
        builder.field("include_upper", this.includeUpper);
        if (this.geoDistance != null) {
            builder.field("distance_type", this.geoDistance.name().toLowerCase(Locale.ROOT));
        }
        if (this.optimizeBbox != null) {
            builder.field("optimize_bbox", this.optimizeBbox);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        if (this.coerce != null) {
            builder.field("coerce", (Object)this.coerce);
        }
        if (this.ignoreMalformed != null) {
            builder.field("ignore_malformed", (Object)this.ignoreMalformed);
        }
        builder.endObject();
    }
}

