/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import jxl.biff.formula.ExternalSheet;

public class CellReferenceHelper {
    public static void getCellReference(int column, int row, StringBuffer buf) {
        char col;
        int v = column / 26;
        int r = column % 26;
        StringBuffer tmp = new StringBuffer();
        while (v != 0) {
            col = (char)(65 + r);
            tmp.append(col);
            r = v % 26 - 1;
            v /= 26;
        }
        col = (char)(65 + r);
        tmp.append(col);
        int i = tmp.length() - 1;
        while (i >= 0) {
            buf.append(tmp.charAt(i));
            --i;
        }
        buf.append(Integer.toString(row + 1));
    }

    public static void getCellReference(int sheet, int column, int row, ExternalSheet workbook, StringBuffer buf) {
        buf.append(workbook.getExternalSheetName(sheet));
        buf.append('!');
        CellReferenceHelper.getCellReference(column, row, buf);
    }

    public static String getCellReference(int column, int row) {
        StringBuffer buf = new StringBuffer();
        CellReferenceHelper.getCellReference(column, row, buf);
        return buf.toString();
    }

    public static int getColumn(String s) {
        int colnum = 0;
        int numindex = CellReferenceHelper.getNumberIndex(s);
        String s2 = s.toUpperCase();
        int i = 0;
        while (i < numindex) {
            colnum *= 26;
            colnum += s2.charAt(i) - 65;
            ++i;
        }
        return colnum;
    }

    public static int getRow(String s) {
        try {
            return Integer.parseInt(s.substring(CellReferenceHelper.getNumberIndex(s))) - 1;
        }
        catch (NumberFormatException e) {
            System.err.println("Warning:  " + e.toString());
            return 65535;
        }
    }

    private static int getNumberIndex(String s) {
        boolean numberFound = false;
        int pos = 0;
        char c = '\u0000';
        while (!numberFound && pos < s.length()) {
            c = s.charAt(pos);
            if (c >= '0' && c <= '9') {
                numberFound = true;
                continue;
            }
            ++pos;
        }
        return pos;
    }
}

