/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.support;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.security.support.KeyStoreFactoryBean;

public abstract class KeyStoreUtils {
    public static KeyStore loadDefaultKeyStore() throws GeneralSecurityException, IOException {
        FileSystemResource location = null;
        String type = null;
        String password = null;
        String locationProperty = System.getProperty("javax.net.ssl.keyStore");
        if (StringUtils.hasLength((String)locationProperty)) {
            String passwordProperty;
            File f = new File(locationProperty);
            if (f.exists() && f.isFile() && f.canRead()) {
                location = new FileSystemResource(f);
            }
            if (StringUtils.hasLength((String)(passwordProperty = System.getProperty("javax.net.ssl.keyStorePassword")))) {
                password = passwordProperty;
            }
            type = System.getProperty("javax.net.ssl.keyStoreType");
        }
        KeyStoreFactoryBean factoryBean = new KeyStoreFactoryBean();
        factoryBean.setLocation((Resource)location);
        factoryBean.setPassword(password);
        factoryBean.setType(type);
        factoryBean.afterPropertiesSet();
        return factoryBean.getObject();
    }

    public static KeyStore loadDefaultTrustStore() throws GeneralSecurityException, IOException {
        FileSystemResource location = null;
        String type = null;
        String password = null;
        String locationProperty = System.getProperty("javax.net.ssl.trustStore");
        if (StringUtils.hasLength((String)locationProperty)) {
            String passwordProperty;
            File f = new File(locationProperty);
            if (f.exists() && f.isFile() && f.canRead()) {
                location = new FileSystemResource(f);
            }
            if (StringUtils.hasLength((String)(passwordProperty = System.getProperty("javax.net.ssl.trustStorePassword")))) {
                password = passwordProperty;
            }
            type = System.getProperty("javax.net.ssl.trustStoreType");
        } else {
            String javaHome = System.getProperty("java.home");
            location = new FileSystemResource(javaHome + "/lib/security/jssecacerts");
            if (!location.exists()) {
                location = new FileSystemResource(javaHome + "/lib/security/cacerts");
            }
        }
        KeyStoreFactoryBean factoryBean = new KeyStoreFactoryBean();
        factoryBean.setLocation((Resource)location);
        factoryBean.setPassword(password);
        factoryBean.setType(type);
        factoryBean.afterPropertiesSet();
        return factoryBean.getObject();
    }
}

