/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.fault;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.NamespaceHelper;
import org.codehaus.xfire.util.jdom.StaxBuilder;
import org.codehaus.xfire.util.jdom.StaxSerializer;
import org.codehaus.xfire.util.stax.FragmentStreamReader;
import org.jdom.Element;

public class Soap11FaultSerializer
implements MessageSerializer {
    public void readMessage(InMessage message, MessageContext context) throws XFireFault {
        XFireFault fault = new XFireFault();
        XMLStreamReader reader = message.getXMLStreamReader();
        try {
            boolean end = false;
            while (!end && reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 7: {
                        String encoding = reader.getCharacterEncodingScheme();
                        message.setEncoding(encoding);
                        break;
                    }
                    case 8: {
                        end = true;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        if (reader.getLocalName().equals("faultcode")) {
                            fault.setFaultCode(NamespaceHelper.readQName(reader));
                            break;
                        }
                        if (reader.getLocalName().equals("faultstring")) {
                            fault.setMessage(reader.getElementText());
                            break;
                        }
                        if (reader.getLocalName().equals("faultactor")) {
                            fault.setRole(reader.getElementText());
                            break;
                        }
                        if (!reader.getLocalName().equals("detail")) break;
                        StaxBuilder builder = new StaxBuilder();
                        fault.setDetail(builder.build(new FragmentStreamReader(reader)).getRootElement());
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Could not parse message.", e, XFireFault.SENDER);
        }
        message.setBody(fault);
    }

    public void writeMessage(OutMessage message, XMLStreamWriter writer, MessageContext context) throws XFireFault {
        XFireFault fault = (XFireFault)message.getBody();
        try {
            String codeString;
            Map namespaces = fault.getNamespaces();
            if (namespaces != null) {
                Iterator itr = namespaces.keySet().iterator();
                while (itr.hasNext()) {
                    String prefix = (String)itr.next();
                    writer.writeAttribute("xmlns:" + prefix, (String)namespaces.get(prefix));
                }
            }
            writer.writeStartElement("soap:Fault");
            writer.writeStartElement("faultcode");
            QName faultCode = fault.getFaultCode();
            if (faultCode.equals(XFireFault.RECEIVER)) {
                codeString = "soap:Server";
            } else if (faultCode.equals(XFireFault.SENDER)) {
                codeString = "soap:Client";
            } else if (faultCode.equals(XFireFault.VERSION_MISMATCH)) {
                codeString = "soap:VersionMismatch";
            } else if (faultCode.equals(XFireFault.MUST_UNDERSTAND)) {
                codeString = "soap:MustUnderstand";
            } else if (faultCode.equals(XFireFault.DATA_ENCODING_UNKNOWN)) {
                codeString = "soap:Client";
            } else {
                String ns = faultCode.getNamespaceURI();
                String prefix = faultCode.getPrefix();
                if (ns.length() > 0 && prefix.length() == 0) {
                    prefix = NamespaceHelper.getUniquePrefix(writer, ns, true) + ":";
                } else if (prefix.length() > 0) {
                    writer.writeNamespace(prefix, ns);
                    prefix = prefix + ":";
                }
                codeString = prefix + faultCode.getLocalPart();
            }
            writer.writeCharacters(codeString);
            writer.writeEndElement();
            writer.writeStartElement("faultstring");
            writer.writeCharacters(fault.getMessage());
            writer.writeEndElement();
            if (fault.hasDetails()) {
                Element detail = fault.getDetail();
                writer.writeStartElement("detail");
                StaxSerializer serializer = new StaxSerializer();
                List details = detail.getContent();
                for (int i = 0; i < details.size(); ++i) {
                    serializer.writeElement((Element)details.get(i), writer);
                }
                writer.writeEndElement();
            }
            if (fault.getRole() != null) {
                writer.writeStartElement("faultactor");
                writer.writeCharacters(fault.getRole());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException xe) {
            throw new XFireRuntimeException("Couldn't create fault.", xe);
        }
    }
}

