/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.smb.DfsReferral;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbTransport;
import jcifs.util.LogStream;

public class Dfs {
    static LogStream log = LogStream.getInstance();
    static final boolean strictView = Config.getBoolean("jcifs.smb.client.dfs.strictView", false);
    static final long TTL = Config.getLong("jcifs.smb.client.dfs.ttl", 300L);
    static final boolean DISABLED = Config.getBoolean("jcifs.smb.client.dfs.disabled", false);
    protected static CacheEntry FALSE_ENTRY = new CacheEntry(0L);
    protected CacheEntry _domains = null;
    protected CacheEntry referrals = null;

    public HashMap getTrustedDomains(NtlmPasswordAuthentication auth) throws SmbAuthException {
        block8: {
            if (DISABLED || auth.domain == "?") {
                return null;
            }
            if (this._domains != null && System.currentTimeMillis() > this._domains.expiration) {
                this._domains = null;
            }
            if (this._domains != null) {
                return this._domains.map;
            }
            try {
                UniAddress addr = UniAddress.getByName(auth.domain, true);
                SmbTransport trans = SmbTransport.getSmbTransport(addr, 0);
                CacheEntry entry = new CacheEntry(TTL * 10L);
                DfsReferral dr = trans.getDfsReferrals(auth, "", 0);
                if (dr != null) {
                    DfsReferral start = dr;
                    do {
                        String domain = dr.server.toLowerCase();
                        entry.map.put(domain, new HashMap());
                    } while ((dr = dr.next) != start);
                    this._domains = entry;
                    return this._domains.map;
                }
            }
            catch (IOException ioe) {
                if (LogStream.level >= 3) {
                    ioe.printStackTrace(log);
                }
                if (!strictView || !(ioe instanceof SmbAuthException)) break block8;
                throw (SmbAuthException)ioe;
            }
        }
        return null;
    }

    public boolean isTrustedDomain(String domain, NtlmPasswordAuthentication auth) throws SmbAuthException {
        HashMap domains = this.getTrustedDomains(auth);
        if (domains == null) {
            return false;
        }
        return domains.get(domain = domain.toLowerCase()) != null;
    }

    public SmbTransport getDc(String domain, NtlmPasswordAuthentication auth) throws SmbAuthException {
        block8: {
            if (DISABLED) {
                return null;
            }
            try {
                UniAddress addr = UniAddress.getByName(domain, true);
                SmbTransport trans = SmbTransport.getSmbTransport(addr, 0);
                DfsReferral dr = trans.getDfsReferrals(auth, "\\" + domain, 1);
                if (dr != null) {
                    DfsReferral start = dr;
                    IOException e = null;
                    while (true) {
                        try {
                            addr = UniAddress.getByName(dr.server);
                            return SmbTransport.getSmbTransport(addr, 0);
                        }
                        catch (IOException ioe) {
                            e = ioe;
                            if ((dr = dr.next) != start) continue;
                            throw e;
                        }
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                if (LogStream.level >= 3) {
                    ioe.printStackTrace(log);
                }
                if (!strictView || !(ioe instanceof SmbAuthException)) break block8;
                throw (SmbAuthException)ioe;
            }
        }
        return null;
    }

    public DfsReferral getReferral(SmbTransport trans, String domain, String root, String path, NtlmPasswordAuthentication auth) throws SmbAuthException {
        block6: {
            if (DISABLED) {
                return null;
            }
            try {
                DfsReferral dr;
                String p = "\\" + domain + "\\" + root;
                if (path != null) {
                    p = p + path;
                }
                if ((dr = trans.getDfsReferrals(auth, p, 0)) != null) {
                    return dr;
                }
            }
            catch (IOException ioe) {
                if (LogStream.level >= 4) {
                    ioe.printStackTrace(log);
                }
                if (!strictView || !(ioe instanceof SmbAuthException)) break block6;
                throw (SmbAuthException)ioe;
            }
        }
        return null;
    }

    public synchronized DfsReferral resolve(String domain, String root, String path, NtlmPasswordAuthentication auth) throws SmbAuthException {
        HashMap roots;
        DfsReferral dr = null;
        long now = System.currentTimeMillis();
        if (DISABLED || root.equals("IPC$")) {
            return null;
        }
        HashMap domains = this.getTrustedDomains(auth);
        if (domains != null && (roots = (HashMap)domains.get(domain = domain.toLowerCase())) != null) {
            SmbTransport trans = null;
            CacheEntry links = (CacheEntry)roots.get(root = root.toLowerCase());
            if (links != null && now > links.expiration) {
                roots.remove(root);
                links = null;
            }
            if (links == null) {
                trans = this.getDc(domain, auth);
                if (trans == null) {
                    return null;
                }
                dr = this.getReferral(trans, domain, root, path, auth);
                if (dr != null) {
                    int len = 1 + domain.length() + 1 + root.length();
                    links = new CacheEntry(0L);
                    DfsReferral tmp = dr;
                    do {
                        if (path == null) {
                            tmp.map = links.map;
                            tmp.key = "\\";
                        }
                        tmp.pathConsumed -= len;
                    } while ((tmp = tmp.next) != dr);
                    if (dr.key != null) {
                        links.map.put(dr.key, dr);
                    }
                    roots.put(root, links);
                } else if (path == null) {
                    roots.put(root, FALSE_ENTRY);
                }
            } else if (links == FALSE_ENTRY) {
                links = null;
            }
            if (links != null) {
                String link = "\\";
                dr = (DfsReferral)links.map.get(link);
                if (dr != null && now > dr.expiration) {
                    links.map.remove(link);
                    dr = null;
                }
                if (dr == null) {
                    if (trans == null && (trans = this.getDc(domain, auth)) == null) {
                        return null;
                    }
                    dr = this.getReferral(trans, domain, root, path, auth);
                    if (dr != null) {
                        dr.pathConsumed -= 1 + domain.length() + 1 + root.length();
                        dr.link = link;
                        links.map.put(link, dr);
                    }
                }
            }
        }
        if (dr == null && path != null) {
            if (this.referrals != null && now > this.referrals.expiration) {
                this.referrals = null;
            }
            if (this.referrals == null) {
                this.referrals = new CacheEntry(0L);
            }
            String key = "\\" + domain + "\\" + root;
            if (!path.equals("\\")) {
                key = key + path;
            }
            key = key.toLowerCase();
            Iterator iter = this.referrals.map.keySet().iterator();
            while (iter.hasNext()) {
                String _key = (String)iter.next();
                int _klen = _key.length();
                boolean match = false;
                if (_klen == key.length()) {
                    match = _key.equals(key);
                } else if (_klen < key.length()) {
                    boolean bl = match = _key.regionMatches(0, key, 0, _klen) && key.charAt(_klen) == '\\';
                }
                if (!match) continue;
                dr = (DfsReferral)this.referrals.map.get(_key);
            }
        }
        return dr;
    }

    synchronized void insert(String path, DfsReferral dr) {
        int ki;
        if (DISABLED) {
            return;
        }
        int s1 = path.indexOf(92, 1);
        int s2 = path.indexOf(92, s1 + 1);
        String server = path.substring(1, s1);
        String share = path.substring(s1 + 1, s2);
        String key = path.substring(0, dr.pathConsumed).toLowerCase();
        for (ki = key.length(); ki > 1 && key.charAt(ki - 1) == '\\'; --ki) {
        }
        if (ki < key.length()) {
            key = key.substring(0, ki);
        }
        dr.pathConsumed -= 1 + server.length() + 1 + share.length();
        if (this.referrals != null && System.currentTimeMillis() + 10000L > this.referrals.expiration) {
            this.referrals = null;
        }
        if (this.referrals == null) {
            this.referrals = new CacheEntry(0L);
        }
        this.referrals.map.put(key, dr);
    }

    static class CacheEntry {
        long expiration;
        HashMap map;

        CacheEntry(long ttl) {
            if (ttl == 0L) {
                ttl = TTL;
            }
            this.expiration = System.currentTimeMillis() + ttl * 1000L;
            this.map = new HashMap();
        }
    }
}

