/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.client.support.AbstractClient;
import org.elasticsearch.client.support.Headers;
import org.elasticsearch.client.transport.ClientTransportModule;
import org.elasticsearch.client.transport.TransportClientNodesService;
import org.elasticsearch.client.transport.support.TransportProxyClient;
import org.elasticsearch.cluster.ClusterNameModule;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.indices.breaker.CircuitBreakerModule;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.node.internal.InternalSettingsPreparer;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsModule;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolModule;
import org.elasticsearch.transport.TransportModule;
import org.elasticsearch.transport.TransportService;

public class TransportClient
extends AbstractClient {
    public static final String CLIENT_TYPE = "transport";
    final Injector injector;
    private final TransportClientNodesService nodesService;
    private final TransportProxyClient proxy;

    public static Builder builder() {
        return new Builder();
    }

    private TransportClient(Injector injector) {
        super(injector.getInstance(Settings.class), injector.getInstance(ThreadPool.class), injector.getInstance(Headers.class));
        this.injector = injector;
        this.nodesService = injector.getInstance(TransportClientNodesService.class);
        this.proxy = injector.getInstance(TransportProxyClient.class);
    }

    TransportClientNodesService nodeService() {
        return this.nodesService;
    }

    public List<TransportAddress> transportAddresses() {
        return this.nodesService.transportAddresses();
    }

    public List<DiscoveryNode> connectedNodes() {
        return this.nodesService.connectedNodes();
    }

    public List<DiscoveryNode> filteredNodes() {
        return this.nodesService.filteredNodes();
    }

    public List<DiscoveryNode> listedNodes() {
        return this.nodesService.listedNodes();
    }

    public TransportClient addTransportAddress(TransportAddress transportAddress) {
        this.nodesService.addTransportAddresses(transportAddress);
        return this;
    }

    public TransportClient addTransportAddresses(TransportAddress ... transportAddress) {
        this.nodesService.addTransportAddresses(transportAddress);
        return this;
    }

    public TransportClient removeTransportAddress(TransportAddress transportAddress) {
        this.nodesService.removeTransportAddress(transportAddress);
        return this;
    }

    @Override
    public void close() {
        this.injector.getInstance(TransportClientNodesService.class).close();
        this.injector.getInstance(TransportService.class).close();
        try {
            this.injector.getInstance(MonitorService.class).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Class<? extends LifecycleComponent> plugin : this.injector.getInstance(PluginsService.class).nodeServices()) {
            this.injector.getInstance(plugin).close();
        }
        try {
            ThreadPool.terminate(this.injector.getInstance(ThreadPool.class), 10L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.injector.getInstance(PageCacheRecycler.class).close();
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        this.proxy.execute(action, request, listener);
    }

    public static class Builder {
        private Settings settings = Settings.EMPTY;
        private List<Class<? extends Plugin>> pluginClasses = new ArrayList<Class<? extends Plugin>>();

        public Builder settings(Settings.Builder settings) {
            return this.settings(settings.build());
        }

        public Builder settings(Settings settings) {
            if (settings.get("plugin.types") != null) {
                throw new IllegalArgumentException("plugin.types is no longer supported. Use the addPlugin method on TransportClient.");
            }
            this.settings = settings;
            return this;
        }

        public Builder addPlugin(Class<? extends Plugin> pluginClass) {
            this.pluginClasses.add(pluginClass);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransportClient build() {
            Settings settings = InternalSettingsPreparer.prepareSettings(this.settings);
            settings = Settings.settingsBuilder().put("transport.ping_schedule", "5s").put(settings).put("network.server", false).put("node.client", true).put("client.type", TransportClient.CLIENT_TYPE).build();
            PluginsService pluginsService = new PluginsService(settings, null, null, this.pluginClasses);
            this.settings = pluginsService.updatedSettings();
            Version version = Version.CURRENT;
            ThreadPool threadPool = new ThreadPool(settings);
            boolean success = false;
            try {
                ModulesBuilder modules = new ModulesBuilder();
                modules.add(new Version.Module(version));
                for (Module pluginModule : pluginsService.nodeModules()) {
                    modules.add(pluginModule);
                }
                modules.add(new PluginsModule(pluginsService));
                modules.add(new SettingsModule(this.settings));
                modules.add(new NetworkModule());
                modules.add(new ClusterNameModule(this.settings));
                modules.add(new ThreadPoolModule(threadPool));
                modules.add(new TransportModule(this.settings));
                modules.add(new SearchModule(){

                    @Override
                    protected void configure() {
                    }
                });
                modules.add(new ActionModule(true));
                modules.add(new ClientTransportModule());
                modules.add(new CircuitBreakerModule(this.settings));
                pluginsService.processModules(modules);
                Injector injector = modules.createInjector();
                injector.getInstance(TransportService.class).start();
                TransportClient transportClient = new TransportClient(injector);
                success = true;
                TransportClient transportClient2 = transportClient;
                return transportClient2;
            }
            finally {
                if (!success) {
                    ThreadPool.terminate(threadPool, 10L, TimeUnit.SECONDS);
                }
            }
        }
    }
}

