/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics.sum;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.InternalSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorStreams;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsPipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class SumBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("sum_bucket");
    public static final PipelineAggregatorStreams.Stream STREAM = new PipelineAggregatorStreams.Stream(){

        @Override
        public SumBucketPipelineAggregator readResult(StreamInput in) throws IOException {
            SumBucketPipelineAggregator result = new SumBucketPipelineAggregator();
            result.readFrom(in);
            return result;
        }
    };
    private double sum = 0.0;

    public static void registerStreams() {
        PipelineAggregatorStreams.registerStream(STREAM, TYPE.stream());
    }

    private SumBucketPipelineAggregator() {
    }

    protected SumBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, ValueFormatter formatter, Map<String, Object> metaData) {
        super(name, bucketsPaths, gapPolicy, formatter, metaData);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    protected void preCollection() {
        this.sum = 0.0;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        this.sum += bucketValue.doubleValue();
    }

    @Override
    protected InternalAggregation buildAggregation(List<PipelineAggregator> pipelineAggregators, Map<String, Object> metadata) {
        return new InternalSimpleValue(this.name(), this.sum, this.formatter, pipelineAggregators, metadata);
    }

    public static class Factory
    extends PipelineAggregatorFactory {
        private final ValueFormatter formatter;
        private final BucketHelpers.GapPolicy gapPolicy;

        public Factory(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, ValueFormatter formatter) {
            super(name, TYPE.name(), bucketsPaths);
            this.gapPolicy = gapPolicy;
            this.formatter = formatter;
        }

        @Override
        protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
            return new SumBucketPipelineAggregator(this.name, this.bucketsPaths, this.gapPolicy, this.formatter, metaData);
        }

        @Override
        public void doValidate(AggregatorFactory parent, AggregatorFactory[] aggFactories, List<PipelineAggregatorFactory> pipelineAggregatorFactories) {
            if (this.bucketsPaths.length != 1) {
                throw new IllegalStateException(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " must contain a single entry for aggregation [" + this.name + "]");
            }
        }
    }
}

