/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.File;
import jxl.Cell;
import jxl.Range;
import jxl.Workbook;
import jxl.demo.BiffDump;
import jxl.demo.CSV;
import jxl.demo.Formulas;
import jxl.demo.ReadWrite;
import jxl.demo.Write;
import jxl.demo.WriteAccess;
import jxl.demo.XML;

public class Demo {
    private static final int CSVFormat = 13;
    private static final int XMLFormat = 14;

    private static void displayHelp() {
        System.err.println("Command format:  Demo [-unicode] [-csv] [-hide] excelfile");
        System.err.println("                 Demo -xml [-format]  excelfile");
        System.err.println("                 Demo -write excelfile");
        System.err.println("                 Demo -formulas excelfile");
        System.err.println("                 Demo -readwrite|-rw excelfile output");
        System.err.println("                 Demo -biffdump | -bd | -wa excelfile");
        System.err.println("                 Demo -version");
        System.err.println("                 Demo -h|-help");
    }

    public static void main(String[] args) {
        block35: {
            if (args.length == 0) {
                Demo.displayHelp();
                System.exit(1);
            }
            if (args[0].equals("-help") || args[0].equals("-h")) {
                Demo.displayHelp();
                System.exit(1);
            }
            if (args[0].equals("-version")) {
                System.out.println("v" + Workbook.getVersion());
                System.exit(0);
            }
            boolean write = false;
            boolean readwrite = false;
            boolean formulas = false;
            boolean biffdump = false;
            boolean jxlversion = false;
            String file = args[0];
            String outputFile = null;
            if (args[0].equals("-write")) {
                write = true;
                file = args[1];
            } else if (args[0].equals("-formulas")) {
                formulas = true;
                file = args[1];
            } else if (args[0].equals("-biffdump") || args[0].equals("-bd")) {
                biffdump = true;
                file = args[1];
            } else if (args[0].equals("-wa")) {
                jxlversion = true;
                file = args[1];
            } else if (args[0].equals("-readwrite") || args[0].equals("-rw")) {
                readwrite = true;
                file = args[1];
                outputFile = args[2];
            } else {
                file = args[args.length - 1];
            }
            String encoding = "UTF8";
            int format = 13;
            boolean formatInfo = false;
            boolean hideCells = false;
            if (!(write || readwrite || formulas || biffdump || jxlversion)) {
                int i = 0;
                while (i < args.length - 1) {
                    if (args[i].equals("-unicode")) {
                        encoding = "UnicodeBig";
                    } else if (args[i].equals("-xml")) {
                        format = 14;
                    } else if (args[i].equals("-csv")) {
                        format = 13;
                    } else if (args[i].equals("-format")) {
                        formatInfo = true;
                    } else if (args[i].equals("-hide")) {
                        hideCells = true;
                    } else {
                        System.err.println("Command format:  CSV [-unicode] [-xml|-csv] excelfile");
                        System.exit(1);
                    }
                    ++i;
                }
            }
            try {
                if (write) {
                    Write w = new Write(file);
                    w.write();
                    break block35;
                }
                if (readwrite) {
                    ReadWrite rw = new ReadWrite(file, outputFile);
                    rw.readWrite();
                    break block35;
                }
                if (formulas) {
                    Workbook w = Workbook.getWorkbook(new File(file));
                    Formulas f = new Formulas(w, System.out, encoding);
                    w.close();
                    break block35;
                }
                if (biffdump) {
                    BiffDump bd = new BiffDump(new File(file), System.out);
                    break block35;
                }
                if (jxlversion) {
                    WriteAccess bd = new WriteAccess(new File(file));
                    break block35;
                }
                Workbook w = Workbook.getWorkbook(new File(file));
                if (format == 13) {
                    CSV csv = new CSV(w, System.out, encoding, hideCells);
                } else if (format == 14) {
                    XML xml = new XML(w, System.out, encoding, formatInfo);
                }
                w.close();
            }
            catch (Throwable t) {
                System.out.println(t.toString());
                t.printStackTrace();
            }
        }
    }

    private static void findTest(Workbook w) {
        int i;
        Range[] range;
        System.out.println("Find test");
        Cell c = w.findCellByName("named1");
        if (c != null) {
            System.out.println("named1 contents:  " + c.getContents());
        }
        if ((c = w.findCellByName("named2")) != null) {
            System.out.println("named2 contents:  " + c.getContents());
        }
        if ((c = w.findCellByName("namedrange")) != null) {
            System.out.println("named2 contents:  " + c.getContents());
        }
        if ((range = w.findByName("namedrange")) != null) {
            c = range[0].getTopLeft();
            System.out.println("namedrange top left contents:  " + c.getContents());
            c = range[0].getBottomRight();
            System.out.println("namedrange bottom right contents:  " + c.getContents());
        }
        if ((range = w.findByName("nonadjacentrange")) != null) {
            i = 0;
            while (i < range.length) {
                c = range[i].getTopLeft();
                System.out.println("nonadjacent top left contents:  " + c.getContents());
                c = range[i].getBottomRight();
                System.out.println("nonadjacent bottom right contents:  " + c.getContents());
                ++i;
            }
        }
        if ((range = w.findByName("horizontalnonadjacentrange")) != null) {
            i = 0;
            while (i < range.length) {
                c = range[i].getTopLeft();
                System.out.println("horizontalnonadjacent top left contents:  " + c.getContents());
                c = range[i].getBottomRight();
                System.out.println("horizontalnonadjacent bottom right contents:  " + c.getContents());
                ++i;
            }
        }
    }
}

