/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.read.biff.BiffException;
import jxl.read.biff.CompoundFile;
import jxl.read.biff.Record;

public class File {
    private byte[] data;
    private int pos;
    private int oldPos;
    private int initialFileSize;
    private int arrayGrowSize;
    private WorkbookSettings workbookSettings;

    /*
     * Unable to fully structure code
     */
    public File(InputStream is, WorkbookSettings ws) throws IOException, BiffException {
        super();
        this.workbookSettings = ws;
        this.initialFileSize = this.workbookSettings.getInitialFileSize();
        this.arrayGrowSize = this.workbookSettings.getArrayGrowSize();
        d = new byte[this.initialFileSize];
        pos = bytesRead = is.read(d);
        if (!Thread.currentThread().isInterrupted()) ** GOTO lbl17
        throw new InterruptedIOException();
lbl-1000:
        // 1 sources

        {
            if (pos >= d.length) {
                newArray = new byte[d.length + this.arrayGrowSize];
                System.arraycopy(d, 0, newArray, 0, d.length);
                d = newArray;
            }
            bytesRead = is.read(d, pos, d.length - pos);
            pos += bytesRead;
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedIOException();
lbl17:
            // 2 sources

            ** while (bytesRead != -1)
        }
lbl18:
        // 1 sources

        bytesRead = pos + 1;
        if (bytesRead == 0) {
            throw new BiffException(BiffException.excelFileNotFound);
        }
        cf = new CompoundFile(d);
        try {
            this.data = cf.getStream("workbook");
        }
        catch (BiffException e) {
            this.data = cf.getStream("book");
        }
        cf = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
    }

    Record next() {
        Record r = new Record(this.data, this.pos, this);
        return r;
    }

    Record peek() {
        int tempPos = this.pos;
        Record r = new Record(this.data, this.pos, this);
        this.pos = tempPos;
        return r;
    }

    public void skip(int bytes) {
        this.pos += bytes;
    }

    public byte[] read(int pos, int length) {
        byte[] ret = new byte[length];
        System.arraycopy(this.data, pos, ret, 0, length);
        return ret;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int p) {
        this.oldPos = this.pos;
        this.pos = p;
    }

    public void restorePos() {
        this.pos = this.oldPos;
    }

    private void moveToFirstBof() {
        boolean bofFound = false;
        while (!bofFound) {
            int code = IntegerHelper.getInt(this.data[this.pos], this.data[this.pos + 1]);
            if (code == Type.BOF.value) {
                bofFound = true;
                continue;
            }
            this.skip(128);
        }
    }

    public void close() {
    }

    public void clear() {
        this.data = null;
    }

    public boolean hasNext() {
        return this.pos < this.data.length - 4;
    }
}

