/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class SupbookRecord
extends WritableRecordData {
    private byte[] data;
    private int numSheets;
    private String fileName;
    private String[] sheetNames;

    public SupbookRecord(int sheets) {
        super(Type.SUPBOOK);
        this.numSheets = sheets;
        this.data = new byte[4];
        IntegerHelper.getTwoBytes(sheets, this.data, 0);
        this.data[2] = 1;
        this.data[3] = 4;
    }

    public SupbookRecord(jxl.read.biff.SupbookRecord sr) {
        super(Type.SUPBOOK);
        if (sr.getType() == jxl.read.biff.SupbookRecord.INTERNAL) {
            this.initInternal(sr);
        } else if (sr.getType() == jxl.read.biff.SupbookRecord.EXTERNAL) {
            this.initExternal(sr);
        }
    }

    private void initInternal(jxl.read.biff.SupbookRecord sr) {
        this.numSheets = sr.getNumberOfSheets();
        this.data = new byte[4];
        IntegerHelper.getTwoBytes(this.numSheets, this.data, 0);
        this.data[2] = 1;
        this.data[3] = 4;
    }

    private void initExternal(jxl.read.biff.SupbookRecord sr) {
        this.numSheets = sr.getNumberOfSheets();
        this.fileName = sr.getFileName();
        this.sheetNames = new String[this.numSheets];
        int totalSheetNameLength = 0;
        int i = 0;
        while (i < this.numSheets) {
            this.sheetNames[i] = sr.getSheetName(i);
            totalSheetNameLength += this.sheetNames[i].length();
            ++i;
        }
        int dataLength = 6 + this.fileName.length() + this.numSheets * 3 + totalSheetNameLength * 2;
        this.data = new byte[dataLength];
        IntegerHelper.getTwoBytes(this.numSheets, this.data, 0);
        int pos = 2;
        IntegerHelper.getTwoBytes(this.fileName.length() + 1, this.data, pos);
        this.data[pos + 2] = 0;
        this.data[pos + 3] = 1;
        StringHelper.getBytes(this.fileName, this.data, pos + 4);
        pos += 4 + this.fileName.length();
        int i2 = 0;
        while (i2 < this.sheetNames.length) {
            IntegerHelper.getTwoBytes(this.sheetNames[i2].length(), this.data, pos);
            this.data[pos + 2] = 1;
            StringHelper.getUnicodeBytes(this.sheetNames[i2], this.data, pos + 3);
            pos += 3 + this.sheetNames[i2].length() * 2;
            ++i2;
        }
    }

    public byte[] getData() {
        return this.data;
    }
}

