/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.springframework.util.Assert;

public class CollectionFactory {
    public static Collection<Object> createCollection(Class<?> collectionType, Class<?> elementType, int size) {
        Assert.notNull(collectionType, (String)"Collection type must not be null!");
        if (EnumSet.class.equals(collectionType)) {
            return EnumSet.noneOf(CollectionFactory.asEnumType(elementType));
        }
        return org.springframework.core.CollectionFactory.createCollection(collectionType, (int)size);
    }

    public static Map<Object, Object> createMap(Class<?> mapType, Class<?> keyType, int size) {
        Assert.notNull(mapType, (String)"Map type must not be null!");
        if (EnumMap.class.isAssignableFrom(mapType)) {
            return new EnumMap<Object, Object>(CollectionFactory.asEnumType(keyType));
        }
        return org.springframework.core.CollectionFactory.createMap(mapType, (int)size);
    }

    private static Class<? extends Enum> asEnumType(Class<?> enumType) {
        Assert.notNull(enumType, (String)"EnumType must not be null!");
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new IllegalArgumentException(String.format("Given type %s is not an enum type!", enumType.getName()));
        }
        return enumType.asSubclass(Enum.class);
    }
}

