/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class HttpHeaders
implements MultiValueMap<String, String>,
Serializable {
    private static final long serialVersionUID = -8578554704772377436L;
    private static final String ACCEPT = "Accept";
    private static final String ACCEPT_CHARSET = "Accept-Charset";
    private static final String ALLOW = "Allow";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String CONNECTION = "Connection";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String DATE = "Date";
    private static final String ETAG = "ETag";
    private static final String EXPIRES = "Expires";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String LOCATION = "Location";
    private static final String ORIGIN = "Origin";
    private static final String PRAGMA = "Pragma";
    private static final String UPGRADE = "Upgrade";
    private static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM dd HH:mm:ss yyyy"};
    private static TimeZone GMT = TimeZone.getTimeZone("GMT");
    private final Map<String, List<String>> headers;

    private HttpHeaders(Map<String, List<String>> headers, boolean readOnly) {
        Assert.notNull(headers, (String)"'headers' must not be null");
        if (readOnly) {
            LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap(headers.size(), Locale.ENGLISH);
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                List<String> values = Collections.unmodifiableList(entry.getValue());
                map.put(entry.getKey(), values);
            }
            this.headers = Collections.unmodifiableMap(map);
        } else {
            this.headers = headers;
        }
    }

    public HttpHeaders() {
        this((Map<String, List<String>>)new LinkedCaseInsensitiveMap(8, Locale.ENGLISH), false);
    }

    public static HttpHeaders readOnlyHttpHeaders(HttpHeaders headers) {
        return new HttpHeaders((Map<String, List<String>>)((Object)headers), true);
    }

    public void setAccept(List<MediaType> acceptableMediaTypes) {
        this.set(ACCEPT, MediaType.toString(acceptableMediaTypes));
    }

    public List<MediaType> getAccept() {
        Object acceptHeader;
        List<Object> result;
        String value = this.getFirst(ACCEPT);
        List<Object> list = result = value != null ? MediaType.parseMediaTypes(value) : Collections.emptyList();
        if (result.size() == 1 && (acceptHeader = this.get(ACCEPT)).size() > 1) {
            value = StringUtils.collectionToCommaDelimitedString((Collection)acceptHeader);
            result = MediaType.parseMediaTypes(value);
        }
        return result;
    }

    public void setAcceptCharset(List<Charset> acceptableCharsets) {
        StringBuilder builder = new StringBuilder();
        Iterator<Charset> iterator = acceptableCharsets.iterator();
        while (iterator.hasNext()) {
            Charset charset = iterator.next();
            builder.append(charset.name().toLowerCase(Locale.ENGLISH));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        this.set(ACCEPT_CHARSET, builder.toString());
    }

    public List<Charset> getAcceptCharset() {
        ArrayList<Charset> result = new ArrayList<Charset>();
        String value = this.getFirst(ACCEPT_CHARSET);
        if (value != null) {
            String[] tokens;
            for (String token : tokens = value.split(",\\s*")) {
                int paramIdx = token.indexOf(59);
                String charsetName = paramIdx == -1 ? token : token.substring(0, paramIdx);
                if (charsetName.equals("*")) continue;
                result.add(Charset.forName(charsetName));
            }
        }
        return result;
    }

    public void setAllow(Set<HttpMethod> allowedMethods) {
        this.set(ALLOW, StringUtils.collectionToCommaDelimitedString(allowedMethods));
    }

    public Set<HttpMethod> getAllow() {
        String value = this.getFirst(ALLOW);
        if (!StringUtils.isEmpty((Object)value)) {
            String[] tokens;
            ArrayList<HttpMethod> allowedMethod = new ArrayList<HttpMethod>(5);
            for (String token : tokens = value.split(",\\s*")) {
                allowedMethod.add(HttpMethod.valueOf(token));
            }
            return EnumSet.copyOf(allowedMethod);
        }
        return EnumSet.noneOf(HttpMethod.class);
    }

    public void setCacheControl(String cacheControl) {
        this.set(CACHE_CONTROL, cacheControl);
    }

    public String getCacheControl() {
        return this.getFirst(CACHE_CONTROL);
    }

    public void setConnection(String connection) {
        this.set(CONNECTION, connection);
    }

    public void setConnection(List<String> connection) {
        this.set(CONNECTION, this.toCommaDelimitedString(connection));
    }

    public List<String> getConnection() {
        return this.getFirstValueAsList(CONNECTION);
    }

    public void setContentDispositionFormData(String name, String filename) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        StringBuilder builder = new StringBuilder("form-data; name=\"");
        builder.append(name).append('\"');
        if (filename != null) {
            builder.append("; filename=\"");
            builder.append(filename).append('\"');
        }
        this.set(CONTENT_DISPOSITION, builder.toString());
    }

    public void setContentLength(long contentLength) {
        this.set(CONTENT_LENGTH, Long.toString(contentLength));
    }

    public long getContentLength() {
        String value = this.getFirst(CONTENT_LENGTH);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setContentType(MediaType mediaType) {
        Assert.isTrue((!mediaType.isWildcardType() ? 1 : 0) != 0, (String)"'Content-Type' cannot contain wildcard type '*'");
        Assert.isTrue((!mediaType.isWildcardSubtype() ? 1 : 0) != 0, (String)"'Content-Type' cannot contain wildcard subtype '*'");
        this.set(CONTENT_TYPE, mediaType.toString());
    }

    public MediaType getContentType() {
        String value = this.getFirst(CONTENT_TYPE);
        return value != null ? MediaType.parseMediaType(value) : null;
    }

    public void setDate(long date) {
        this.setDate(DATE, date);
    }

    public long getDate() {
        return this.getFirstDate(DATE);
    }

    public void setETag(String eTag) {
        if (eTag != null) {
            Assert.isTrue((eTag.startsWith("\"") || eTag.startsWith("W/") ? 1 : 0) != 0, (String)"Invalid eTag, does not start with W/ or \"");
            Assert.isTrue((boolean)eTag.endsWith("\""), (String)"Invalid eTag, does not end with \"");
        }
        this.set(ETAG, eTag);
    }

    public String getETag() {
        return this.getFirst(ETAG);
    }

    public void setExpires(long expires) {
        this.setDate(EXPIRES, expires);
    }

    public long getExpires() {
        try {
            return this.getFirstDate(EXPIRES);
        }
        catch (IllegalArgumentException ex) {
            return -1L;
        }
    }

    public void setIfModifiedSince(long ifModifiedSince) {
        this.setDate(IF_MODIFIED_SINCE, ifModifiedSince);
    }

    @Deprecated
    public long getIfNotModifiedSince() {
        return this.getIfModifiedSince();
    }

    public long getIfModifiedSince() {
        return this.getFirstDate(IF_MODIFIED_SINCE);
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.set(IF_NONE_MATCH, ifNoneMatch);
    }

    public void setIfNoneMatch(List<String> ifNoneMatchList) {
        this.set(IF_NONE_MATCH, this.toCommaDelimitedString(ifNoneMatchList));
    }

    protected String toCommaDelimitedString(List<String> list) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String ifNoneMatch = iterator.next();
            builder.append(ifNoneMatch);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public List<String> getIfNoneMatch() {
        return this.getFirstValueAsList(IF_NONE_MATCH);
    }

    protected List<String> getFirstValueAsList(String header) {
        ArrayList<String> result = new ArrayList<String>();
        String value = this.getFirst(header);
        if (value != null) {
            String[] tokens;
            for (String token : tokens = value.split(",\\s*")) {
                result.add(token);
            }
        }
        return result;
    }

    public void setLastModified(long lastModified) {
        this.setDate(LAST_MODIFIED, lastModified);
    }

    public long getLastModified() {
        return this.getFirstDate(LAST_MODIFIED);
    }

    public void setLocation(URI location) {
        this.set(LOCATION, location.toASCIIString());
    }

    public URI getLocation() {
        String value = this.getFirst(LOCATION);
        return value != null ? URI.create(value) : null;
    }

    public void setOrigin(String origin) {
        this.set(ORIGIN, origin);
    }

    public String getOrigin() {
        return this.getFirst(ORIGIN);
    }

    public void setPragma(String pragma) {
        this.set(PRAGMA, pragma);
    }

    public String getPragma() {
        return this.getFirst(PRAGMA);
    }

    public void setUpgrade(String upgrade) {
        this.set(UPGRADE, upgrade);
    }

    public String getUpgrade() {
        return this.getFirst(UPGRADE);
    }

    public long getFirstDate(String headerName) {
        String headerValue = this.getFirst(headerName);
        if (headerValue == null) {
            return -1L;
        }
        for (String dateFormat : DATE_FORMATS) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, Locale.US);
            simpleDateFormat.setTimeZone(GMT);
            try {
                return simpleDateFormat.parse(headerValue).getTime();
            }
            catch (ParseException e) {
            }
        }
        throw new IllegalArgumentException("Cannot parse date value \"" + headerValue + "\" for \"" + headerName + "\" header");
    }

    public void setDate(String headerName, long date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMATS[0], Locale.US);
        dateFormat.setTimeZone(GMT);
        this.set(headerName, dateFormat.format(new Date(date)));
    }

    public String getFirst(String headerName) {
        List<String> headerValues = this.headers.get(headerName);
        return headerValues != null ? headerValues.get(0) : null;
    }

    public void add(String headerName, String headerValue) {
        List<String> headerValues = this.headers.get(headerName);
        if (headerValues == null) {
            headerValues = new LinkedList<String>();
            this.headers.put(headerName, headerValues);
        }
        headerValues.add(headerValue);
    }

    public void set(String headerName, String headerValue) {
        LinkedList<String> headerValues = new LinkedList<String>();
        headerValues.add(headerValue);
        this.headers.put(headerName, headerValues);
    }

    public void setAll(Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> singleValueMap = new LinkedHashMap<String, String>(this.headers.size());
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            singleValueMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return singleValueMap;
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    public List<String> get(Object key) {
        return this.headers.get(key);
    }

    public List<String> put(String key, List<String> value) {
        return this.headers.put(key, value);
    }

    public List<String> remove(Object key) {
        return this.headers.remove(key);
    }

    public void putAll(Map<? extends String, ? extends List<String>> m) {
        this.headers.putAll(m);
    }

    public void clear() {
        this.headers.clear();
    }

    public Set<String> keySet() {
        return this.headers.keySet();
    }

    public Collection<List<String>> values() {
        return this.headers.values();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.entrySet();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpHeaders)) {
            return false;
        }
        HttpHeaders otherHeaders = (HttpHeaders)other;
        return this.headers.equals(otherHeaders.headers);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return this.headers.toString();
    }
}

