/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.mail.monitor;

import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ws.transport.mail.monitor.MonitoringStrategy;

public abstract class AbstractMonitoringStrategy
implements MonitoringStrategy {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean deleteMessages = true;

    public void setDeleteMessages(boolean deleteMessages) {
        this.deleteMessages = deleteMessages;
    }

    public int getFolderOpenMode() {
        return this.deleteMessages ? 2 : 1;
    }

    public final Message[] monitor(Folder folder) throws MessagingException, InterruptedException {
        this.waitForNewMessages(folder);
        Message[] messages = this.searchForNewMessages(folder);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found " + messages.length + " new messages"));
        }
        if (messages.length > 0) {
            this.fetchMessages(folder, messages);
        }
        if (this.deleteMessages) {
            this.deleteMessages(folder, messages);
        }
        return messages;
    }

    protected abstract void waitForNewMessages(Folder var1) throws MessagingException, InterruptedException;

    protected Message[] searchForNewMessages(Folder folder) throws MessagingException {
        if (!folder.isOpen()) {
            return new Message[0];
        }
        Flags supportedFlags = folder.getPermanentFlags();
        Object searchTerm = null;
        if (supportedFlags != null) {
            if (supportedFlags.contains(Flags.Flag.RECENT)) {
                searchTerm = new FlagTerm(new Flags(Flags.Flag.RECENT), true);
            }
            if (supportedFlags.contains(Flags.Flag.ANSWERED)) {
                FlagTerm answeredTerm = new FlagTerm(new Flags(Flags.Flag.ANSWERED), false);
                searchTerm = searchTerm == null ? answeredTerm : new AndTerm((SearchTerm)searchTerm, (SearchTerm)answeredTerm);
            }
            if (supportedFlags.contains(Flags.Flag.DELETED)) {
                FlagTerm deletedTerm = new FlagTerm(new Flags(Flags.Flag.DELETED), false);
                searchTerm = searchTerm == null ? deletedTerm : new AndTerm((SearchTerm)searchTerm, (SearchTerm)deletedTerm);
            }
        }
        return searchTerm != null ? folder.search(searchTerm) : folder.getMessages();
    }

    protected void fetchMessages(Folder folder, Message[] messages) throws MessagingException {
        FetchProfile contentsProfile = new FetchProfile();
        contentsProfile.add(FetchProfile.Item.ENVELOPE);
        contentsProfile.add(FetchProfile.Item.CONTENT_INFO);
        contentsProfile.add(FetchProfile.Item.FLAGS);
        folder.fetch(messages, contentsProfile);
    }

    protected void deleteMessages(Folder folder, Message[] messages) throws MessagingException {
        for (Message message : messages) {
            message.setFlag(Flags.Flag.DELETED, true);
        }
    }
}

