/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.xmpp.support;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppConnectionFactoryBean
implements FactoryBean<XMPPConnection>,
InitializingBean,
DisposableBean {
    private static final int DEFAULT_PORT = 5222;
    private XMPPConnection connection;
    private String host;
    private int port = 5222;
    private String serviceName;
    private String username;
    private String password;
    private String resource;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        Assert.isTrue((port > 0 ? 1 : 0) != 0, (String)"'port' must be larger than 0");
        this.port = port;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void afterPropertiesSet() throws XMPPException {
        ConnectionConfiguration configuration = this.createConnectionConfiguration(this.host, this.port, this.serviceName);
        Assert.notNull((Object)configuration, (String)"'configuration' must not be null");
        Assert.hasText((String)this.username, (String)"'username' must not be empty");
        Assert.hasText((String)this.password, (String)"'password' must not be empty");
        this.connection = new XMPPConnection(configuration);
        this.connection.connect();
        if (StringUtils.hasText((String)this.resource)) {
            this.connection.login(this.username, this.password, this.resource);
        } else {
            this.connection.login(this.username, this.password);
        }
    }

    public void destroy() {
        this.connection.disconnect();
    }

    public XMPPConnection getObject() {
        return this.connection;
    }

    public Class<XMPPConnection> getObjectType() {
        return XMPPConnection.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected ConnectionConfiguration createConnectionConfiguration(String host, int port, String serviceName) {
        Assert.hasText((String)host, (String)"'host' must not be empty");
        if (StringUtils.hasText((String)serviceName)) {
            return new ConnectionConfiguration(host, port, serviceName);
        }
        return new ConnectionConfiguration(host, port);
    }
}

