/*
 * Decompiled with CFR 0.152.
 */
package com.boss.sdk;

import com.boss.sdk.AccountInfo;
import com.boss.sdk.OperatorInfo;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpRequestContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sequenceNo;
    private String ip;
    private OperatorInfo operator;
    private AccountInfo account;
    private String sessionid;
    private ConcurrentHashMap<String, Object> paramMap;
    private ConcurrentHashMap<String, Object> headerMap;
    private String uri;

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getSequenceNo() {
        return this.sequenceNo;
    }

    public void setSequenceNo(String sequenceNo) {
        this.sequenceNo = sequenceNo;
    }

    public String getSessionid() {
        return this.sessionid;
    }

    public OperatorInfo getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorInfo operator) {
        this.operator = operator;
    }

    public AccountInfo getAccount() {
        return this.account;
    }

    public void setAccount(AccountInfo account) {
        this.account = account;
    }

    public ConcurrentHashMap<String, Object> getParamMap() {
        return this.paramMap;
    }

    public void setParamMap(ConcurrentHashMap<String, Object> paramMap) {
        this.paramMap = paramMap;
    }

    public ConcurrentHashMap<String, Object> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeaderMap(ConcurrentHashMap<String, Object> headerMap) {
        this.headerMap = headerMap;
    }

    public HttpRequestContext(String sessionid) {
        this.sessionid = sessionid;
        this.paramMap = new ConcurrentHashMap();
        this.headerMap = new ConcurrentHashMap();
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void addHeader(String name, Object value) {
        if (!this.headerMap.containsKey(name.toLowerCase())) {
            this.headerMap.put(name.toLowerCase(), value);
        }
    }

    public void addParam(String name, Object value) {
        if (value == null) {
            return;
        }
        if (!this.paramMap.containsKey(name.toLowerCase())) {
            this.paramMap.put(name.toLowerCase(), value);
        }
    }

    public int getInt(String name) {
        String tmp = this.getParameter(name);
        return tmp == null || tmp.trim().equals("") ? 0 : Integer.parseInt(tmp);
    }

    public Integer asInteger(String name) {
        String tmp = this.getParameter(name);
        if (tmp == null) {
            return null;
        }
        return Integer.valueOf(tmp);
    }

    public boolean getBoolean(String name) {
        return Boolean.parseBoolean(this.getParameter(name));
    }

    public Boolean asBoolean(String name) {
        String tmp = this.getParameter(name);
        if (tmp == null) {
            return null;
        }
        return Boolean.valueOf(tmp);
    }

    public String getParameter(String name) {
        if (name == null) {
            return null;
        }
        return (String)this.paramMap.get(name.toLowerCase());
    }

    public Object getHeader(String name) {
        return this.headerMap.get(name.toLowerCase());
    }

    public String toString() {
        if (this.paramMap != null) {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, Object> entry : this.paramMap.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            return sb.toString();
        }
        return "";
    }
}

