/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.trust2;

import javax.xml.namespace.QName;
import org.apache.ws.sandbox.security.trust2.exception.ElementParsingException;
import org.apache.ws.sandbox.security.trust2.exception.InvalidSecurityTokenReference;
import org.apache.ws.sandbox.security.trust2.exception.TrustException;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.UsernameToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SecurityTokenOrReference {
    protected Document doc = null;
    protected SecurityTokenReference reference = null;
    protected UsernameToken usernameToken = null;
    protected BinarySecurity binarySecurityToken = null;
    protected boolean isReference;

    public boolean isReference() {
        return this.reference != null;
    }

    public boolean isToken() {
        return this.reference == null;
    }

    public SecurityTokenOrReference(Element element) throws ElementParsingException {
        QName el = new QName(element.getNamespaceURI(), element.getLocalName());
        WSSConfig wssConfig = WSSConfig.getDefaultWSConfig();
        try {
            if (el.equals("SecurityTokenReference")) {
                this.reference = new SecurityTokenReference(element);
            }
            if (el.equals(UsernameToken.TOKEN)) {
                this.usernameToken = new UsernameToken(element);
            }
            if (el.equals(BinarySecurity.TOKEN_BST)) {
                this.binarySecurityToken = new BinarySecurity(element);
            }
            this.doc = element.getOwnerDocument();
        }
        catch (WSSecurityException e) {
            throw new ElementParsingException("WSSecurityException while trying to create a SecurityTokenOrReference object from an XML Element: " + e.getMessage());
        }
    }

    public SecurityTokenOrReference(Element element, Document doc) throws ElementParsingException {
        this(element);
        this.doc = doc;
    }

    public SecurityTokenOrReference(SecurityTokenReference reference) {
        this.reference = reference;
    }

    public SecurityTokenOrReference(UsernameToken securityToken) {
        this.usernameToken = securityToken;
    }

    public SecurityTokenOrReference(BinarySecurity securityToken) {
        this.binarySecurityToken = securityToken;
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public Element getElement() {
        if (this.reference != null) {
            return this.reference.getElement();
        }
        return this.getTokenElement();
    }

    private Element getTokenElement() {
        if (this.usernameToken != null) {
            return this.usernameToken.getElement();
        }
        if (this.binarySecurityToken != null) {
            return this.binarySecurityToken.getElement();
        }
        return null;
    }

    public Object getTokenOrReference() throws TrustException {
        if (this.reference != null) {
            return this.reference;
        }
        return this.resolveToken();
    }

    public Object resolveToken() throws TrustException {
        block9: {
            if (this.usernameToken != null) {
                return this.usernameToken;
            }
            if (this.binarySecurityToken != null) {
                return this.binarySecurityToken;
            }
            if (this.reference != null) {
                try {
                    Element tokenElement = this.reference.getTokenElement(this.doc, null);
                    if (tokenElement == null) break block9;
                    QName el = new QName(tokenElement.getNamespaceURI(), tokenElement.getLocalName());
                    try {
                        WSSConfig wssConfig = WSSConfig.getDefaultWSConfig();
                        if (el.equals(UsernameToken.TOKEN)) {
                            return new UsernameToken(tokenElement);
                        }
                        if (el.equals(BinarySecurity.TOKEN_BST)) {
                            return new BinarySecurity(tokenElement);
                        }
                    }
                    catch (WSSecurityException e) {
                        throw new ElementParsingException("WSSecurityException while trying to create a SecurityToken object from a SecurityTokenReference: " + e.getMessage());
                    }
                }
                catch (WSSecurityException e) {
                    throw new InvalidSecurityTokenReference("WSSecurityException while trying to dereference a <SecurityTokenReference>: " + e.getMessage());
                }
            }
        }
        return null;
    }

    public SecurityTokenReference getReference() {
        return this.reference;
    }

    public UsernameToken getUsernameToken() {
        return this.usernameToken;
    }

    public BinarySecurity getBinarySecurity() {
        return this.binarySecurityToken;
    }
}

