/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db;

import com.coreframework.db.DatabaseEnum;
import com.coreframework.db.Sql;
import com.coreframework.db.impl.TimeoutThread;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;

public class JdbcConnection {
    private static TimeoutThread timeoutGuard = null;
    private static final AtomicLong CONN_ID = new AtomicLong(1L);
    private StringBuffer sb = new StringBuffer();
    private Connection _conn;
    private String db;
    private long connid;
    private DatabaseEnum dbName;
    private String dasUrl;
    private int timeout;
    public boolean isStart;

    static {
        timeoutGuard = new TimeoutThread();
        timeoutGuard.setDaemon(true);
        timeoutGuard.setName("A-ConnectionTimeOutCheck-thread");
        timeoutGuard.start();
    }

    protected void addSql(Sql sql) {
        try {
            this.sb.append(sql).append("|");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Connection getConn() {
        return this._conn;
    }

    @Deprecated
    public DatabaseEnum getDbName() {
        return this.dbName;
    }

    public String getDasUrl() {
        return this.dasUrl;
    }

    @Deprecated
    public JdbcConnection(Connection _conn) {
        this._conn = _conn;
        this.timeout = Integer.getInteger("DB_TIMEOUT", 8000);
        this.connid = CONN_ID.incrementAndGet();
        this.isStart = false;
    }

    public JdbcConnection(Connection _conn, String db) {
        this._conn = _conn;
        this.timeout = Integer.getInteger("DB_TIMEOUT", 8000);
        this.connid = CONN_ID.incrementAndGet();
        this.isStart = false;
        this.db = db;
    }

    public String getDb() {
        return this.db;
    }

    @Deprecated
    public JdbcConnection() {
        this.timeout = Integer.getInteger("DB_TIMEOUT", 8000);
        this.connid = CONN_ID.incrementAndGet();
        this.isStart = false;
    }

    public long getConnid() {
        return this.connid;
    }

    public void setTimeout(int timeoutMills) {
        this.timeout = timeoutMills;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void beginTransaction() throws SQLException {
        this.beginTransaction(this.timeout);
    }

    public void startTimer() {
        if (!this.isStart) {
            timeoutGuard.addTask(this, this.timeout);
            this.isStart = true;
        }
    }

    public void beginTransaction(int timeout) throws SQLException {
        this.timeout = timeout;
        this._conn.setAutoCommit(false);
        this.startTimer();
    }

    public int getTransactionIsolation() throws SQLException {
        return this._conn.getTransactionIsolation();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this._conn.setTransactionIsolation(level);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (!autoCommit) {
            this.beginTransaction();
        }
    }

    public void commitTransaction() throws SQLException {
        this.commit();
    }

    public void commitTransaction(boolean autoRollbackAndClose) throws SQLException {
        try {
            try {
                this.commit();
            }
            catch (SQLException ex) {
                if (autoRollbackAndClose) {
                    this.rollback();
                }
                throw ex;
            }
        }
        finally {
            if (autoRollbackAndClose) {
                this.close();
            }
        }
    }

    public void rollbackAndclose() {
        try {
            try {
                this.rollback();
            }
            catch (Exception exception) {
                try {
                    this.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                this.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public String getSqls() {
        return this.sb.toString();
    }

    public void close() throws SQLException {
        try {
            timeoutGuard.removeTask(this, this.timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._conn == null) {
            return;
        }
        try {
            this._conn.close();
            this._conn = null;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e2) {
            throw new SQLException("connection may has been seted to null", e2);
        }
    }

    public void commit() throws SQLException {
        try {
            this._conn.commit();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e2) {
            throw new SQLException("connection may has been seted to null", e2);
        }
    }

    public void rollback() throws SQLException {
        try {
            this._conn.rollback();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e2) {
            throw new SQLException("connection may has been seted to null", e2);
        }
    }
}

