/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.das.dbutils.handlers;

import com.coreframework.db.QueryResult;
import com.yihu.das.dbutils.RowProcessor;
import com.yihu.das.dbutils.handlers.AbstractListHandler;
import com.yihu.das.dbutils.handlers.ArrayHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ListHandler<T>
extends AbstractListHandler<T> {
    private final RowProcessor convert;

    public ListHandler() {
        this(ArrayHandler.ROW_PROCESSOR);
    }

    public ListHandler(RowProcessor convert) {
        this.convert = convert;
    }

    @Override
    protected T handleRow(ResultSet rs) throws SQLException {
        return (T)rs.getObject(1);
    }

    @Override
    public QueryResult<List<T>> handle(ResultSet rs, int start, int pageSize, int rowCount) throws SQLException {
        ArrayList<T> rows = new ArrayList<T>();
        while (rs.next()) {
            rows.add(this.handleRow(rs));
        }
        QueryResult<List<ArrayList<T>>> qs = new QueryResult<List<ArrayList<T>>>();
        qs.setRowCount(rowCount);
        qs.setResult(rows);
        try {
            int pageCount = (int)Math.ceil((double)rowCount * 1.0 / (double)pageSize);
            qs.setPageCount(pageCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        qs.setPageSize(pageSize);
        return qs;
    }
}

