/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.das.dbutils;

import com.common.json.JSONException;
import com.common.json.JSONObject;
import com.coreframework.db.JDataSet;
import com.yihu.das.dbutils.BeanProcessor;
import com.yihu.das.dbutils.RowProcessor;
import java.io.Reader;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.jtds.jdbc.ClobImpl;

public class BasicRowProcessor
implements RowProcessor {
    private static final BeanProcessor defaultConvert = new BeanProcessor();
    private static final BasicRowProcessor instance = new BasicRowProcessor();
    private final BeanProcessor convert;

    @Deprecated
    public static BasicRowProcessor instance() {
        return instance;
    }

    public BasicRowProcessor() {
        this(defaultConvert);
    }

    public BasicRowProcessor(BeanProcessor convert) {
        this.convert = convert;
    }

    @Override
    public Object[] toArray(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        Object[] result = new Object[cols];
        int i = 0;
        while (i < cols) {
            try {
                result[i] = rs.getObject(i + 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                result[i] = null;
            }
            ++i;
        }
        return result;
    }

    @Override
    public <T> T toBean(ResultSet rs, Class<T> type) throws SQLException {
        return this.convert.toBean(rs, type);
    }

    @Override
    public <T> List<T> toBeanList(ResultSet rs, Class<T> type) throws SQLException {
        return this.convert.toBeanList(rs, type);
    }

    @Override
    public Map<String, Object> toMap(ResultSet rs) throws SQLException {
        CaseInsensitiveHashMap result = new CaseInsensitiveHashMap();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        int i = 1;
        while (i <= cols) {
            Object val = rs.getObject(i);
            if (val != null && val instanceof ClobImpl) {
                Reader reader;
                block8: {
                    reader = rs.getCharacterStream(i);
                    if (reader != null) break block8;
                    return null;
                }
                try {
                    StringBuffer sb = new StringBuffer();
                    char[] charbuf = new char[4096];
                    int j = reader.read(charbuf);
                    while (j > 0) {
                        sb.append(charbuf, 0, j);
                        j = reader.read(charbuf);
                    }
                    val = sb.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (val != null && val instanceof Date) {
                result.put(rsmd.getColumnName(i), rs.getTimestamp(i));
            } else {
                result.put(rsmd.getColumnName(i), val);
            }
            ++i;
        }
        return result;
    }

    @Override
    public JSONObject toJson(ResultSet rs) throws SQLException {
        JSONObject json = new JSONObject();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        int i = 1;
        while (i <= cols) {
            try {
                json.put(rsmd.getColumnName(i), rs.getObject(i));
            }
            catch (JSONException e) {
                throw new SQLException(e.getMessage());
            }
            ++i;
        }
        return json;
    }

    @Override
    public JDataSet toJDateSet(ResultSet rs) throws SQLException {
        long start = System.currentTimeMillis();
        JDataSet jds = new JDataSet();
        try {
            int columnCount = rs.getMetaData().getColumnCount();
            String[] columnNames = new String[columnCount];
            String[] columnTypeNames = new String[columnCount];
            int i = 0;
            while (i < columnCount) {
                columnNames[i] = rs.getMetaData().getColumnName(i + 1);
                columnTypeNames[i] = rs.getMetaData().getColumnTypeName(i + 1);
                ++i;
            }
            jds.setColumnNames(columnNames);
            jds.setColumnTypeNames(columnTypeNames);
            Object[] row = null;
            while (rs.next()) {
                row = new Object[columnCount];
                int i2 = 0;
                while (i2 < columnCount) {
                    row[i2] = rs.getObject(i2 + 1) == null ? null : rs.getObject(i2 + 1);
                    ++i2;
                }
                jds.addRow(row);
            }
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
        return jds;
    }

    private static class CaseInsensitiveHashMap
    extends HashMap<String, Object> {
        private final Map<String, String> lowerCaseMap = new HashMap<String, String>();
        private static final long serialVersionUID = -2848100435296897392L;

        private CaseInsensitiveHashMap() {
        }

        @Override
        public boolean containsKey(Object key) {
            String realKey = this.lowerCaseMap.get(key.toString().toLowerCase());
            return super.containsKey(realKey);
        }

        @Override
        public Object get(Object key) {
            String realKey = this.lowerCaseMap.get(key.toString().toLowerCase());
            return super.get(realKey);
        }

        @Override
        public Object put(String key, Object value) {
            String oldKey = this.lowerCaseMap.put(key.toLowerCase(), key);
            Object oldValue = super.remove(oldKey);
            super.put(key, value);
            return oldValue;
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            for (Map.Entry<String, ?> entry : m.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.put(key, value);
            }
        }

        @Override
        public Object remove(Object key) {
            String realKey = this.lowerCaseMap.remove(key.toString().toLowerCase());
            return super.remove(realKey);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.lowerCaseMap != null) {
                Iterator iterator = super.entrySet().iterator();
                Map.Entry current = null;
                while (iterator.hasNext()) {
                    current = iterator.next();
                    sb.append((String)current.getKey()).append("=").append(current.getValue());
                    sb.append("|");
                }
            }
            return sb.toString();
        }
    }
}

