/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;

public class AggregateTranslator
extends CharSequenceTranslator {
    private final CharSequenceTranslator[] translators;

    public AggregateTranslator(CharSequenceTranslator ... translators) {
        this.translators = ArrayUtils.clone(translators);
    }

    @Override
    public int translate(CharSequence input, int index, Writer out) throws IOException {
        CharSequenceTranslator[] charSequenceTranslatorArray = this.translators;
        int n = this.translators.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequenceTranslator translator = charSequenceTranslatorArray[n2];
            int consumed = translator.translate(input, index, out);
            if (consumed != 0) {
                return consumed;
            }
            ++n2;
        }
        return 0;
    }
}

