/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.io.IOException;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.percolate.PercolateRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class PercolateShardRequest
extends BroadcastShardRequest {
    private String documentType;
    private BytesReference source;
    private BytesReference docSource;
    private boolean onlyCount;
    private int numberOfShards;
    private long startTime;

    public PercolateShardRequest() {
    }

    PercolateShardRequest(ShardId shardId, int numberOfShards, PercolateRequest request) {
        super(shardId, request);
        this.documentType = request.documentType();
        this.source = request.source();
        this.docSource = request.docSource();
        this.onlyCount = request.onlyCount();
        this.numberOfShards = numberOfShards;
        this.startTime = request.startTime;
    }

    PercolateShardRequest(ShardId shardId, OriginalIndices originalIndices) {
        super(shardId, originalIndices);
    }

    PercolateShardRequest(ShardId shardId, PercolateRequest request) {
        super(shardId, request);
        this.documentType = request.documentType();
        this.source = request.source();
        this.docSource = request.docSource();
        this.onlyCount = request.onlyCount();
        this.startTime = request.startTime;
    }

    public String documentType() {
        return this.documentType;
    }

    public BytesReference source() {
        return this.source;
    }

    public BytesReference docSource() {
        return this.docSource;
    }

    public boolean onlyCount() {
        return this.onlyCount;
    }

    void documentType(String documentType) {
        this.documentType = documentType;
    }

    void source(BytesReference source) {
        this.source = source;
    }

    void docSource(BytesReference docSource) {
        this.docSource = docSource;
    }

    void onlyCount(boolean onlyCount) {
        this.onlyCount = onlyCount;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public long getStartTime() {
        return this.startTime;
    }

    OriginalIndices originalIndices() {
        return this.originalIndices;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.documentType = in.readString();
        this.source = in.readBytesReference();
        this.docSource = in.readBytesReference();
        this.onlyCount = in.readBoolean();
        this.numberOfShards = in.readVInt();
        this.startTime = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.documentType);
        out.writeBytesReference(this.source);
        out.writeBytesReference(this.docSource);
        out.writeBoolean(this.onlyCount);
        out.writeVInt(this.numberOfShards);
        out.writeLong(this.startTime);
    }
}

